/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package javax.faces.context;

import java.util.Iterator;
import java.util.Map;
import java.util.List;

import javax.faces.FacesWrapper;
import javax.faces.event.PhaseId;
import javax.faces.component.UIViewRoot;
import javax.faces.render.RenderKit;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.el.ELContext;

/**
 * <p>Provides a simple implementation of {@link FacesContext} that can
 * be subclassed by developers wishing to provide specialized behavior
 * to an existing {@link FacesContext} instance.  The default
 * implementation of all methods is to call through to the wrapped
 * {@link FacesContext} instance.</p>
 *
 * <p>Usage: extend this class and override {@link #getWrapped} to
 * return the instance being wrapping.</p>
 *
 * @since 2.0
 */
public abstract class FacesContextWrapper extends FacesContext implements FacesWrapper<FacesContext> {


    // ----------------------------------------------- Methods from FacesWrapper


    /**
     * @return the wrapped {@link FacesContext} instance
     * @see javax.faces.FacesWrapper#getWrapped()
     */
    public abstract FacesContext getWrapped();


    // ----------------------------------------------- Methods from FacesContext


    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getApplication()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getApplication()
     */
    public Application getApplication() {
        return getWrapped().getApplication();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link javax.faces.context.FacesContext#getClientIdsWithMessages()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see FacesContext#getClientIdsWithMessages()
     */
    public Iterator<String> getClientIdsWithMessages() {
        return getWrapped().getClientIdsWithMessages();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getExternalContext()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getExternalContext()
     */
    public ExternalContext getExternalContext() {
        return getWrapped().getExternalContext();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getMaximumSeverity()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getMaximumSeverity()
     */
    public FacesMessage.Severity getMaximumSeverity() {
        return getWrapped().getMaximumSeverity();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getMessages()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getMessages()
     */
    public Iterator<FacesMessage> getMessages() {
        return getWrapped().getMessages();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getMessages(String)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getMessages(String)
     */
    public Iterator<FacesMessage> getMessages(String clientId) {
        return getWrapped().getMessages(clientId);
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getRenderKit()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getRenderKit()
     */
    public RenderKit getRenderKit() {
        return getWrapped().getRenderKit();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getRenderResponse()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getRenderResponse()
     */
    public boolean getRenderResponse() {
        return getWrapped().getRenderResponse();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getResponseComplete()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getResponseComplete()
     */
    public boolean getResponseComplete() {
        return getWrapped().getResponseComplete();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getResponseStream()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getResponseStream()
     */
    public ResponseStream getResponseStream() {
        return getWrapped().getResponseStream();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#setResponseStream(ResponseStream)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#setResponseStream(ResponseStream)
     */
    public void setResponseStream(ResponseStream responseStream) {
        getWrapped().setResponseStream(responseStream);
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getResponseWriter()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getResponseWriter()
     */
    public ResponseWriter getResponseWriter() {
        return getWrapped().getResponseWriter();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#setResponseWriter(ResponseWriter)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#setResponseWriter(ResponseWriter)
     */
    public void setResponseWriter(ResponseWriter responseWriter) {
        getWrapped().setResponseWriter(responseWriter);
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getViewRoot()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getViewRoot()
     */
    public UIViewRoot getViewRoot() {
        return getWrapped().getViewRoot();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#setViewRoot(UIViewRoot)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#setViewRoot(UIViewRoot)
     */
    public void setViewRoot(UIViewRoot root) {
        getWrapped().setViewRoot(root);
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#addMessage(String, FacesMessage)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#addMessage(String, FacesMessage)
     */
    public void addMessage(String clientId, FacesMessage message) {
        getWrapped().addMessage(clientId, message);
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#release()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#release()
     */
    public void release() {
        getWrapped().release();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#renderResponse()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#renderResponse()
     */
    public void renderResponse() {
        getWrapped().renderResponse();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#responseComplete()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#responseComplete()
     */
    public void responseComplete() {
        getWrapped().responseComplete();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getAttributes()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getAttributes()
     */
    @Override
    public Map<Object, Object> getAttributes() {
        return getWrapped().getAttributes();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getPartialViewContext()} ()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getPartialViewContext()
     */
    @Override
    public PartialViewContext getPartialViewContext() {
        return getWrapped().getPartialViewContext();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getELContext()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getELContext()
     */
    @Override
    public ELContext getELContext() {
        return getWrapped().getELContext();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getFlash()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getFlash()
     */
    @Override
    public Flash getFlash() {
        return getWrapped().getFlash();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getExceptionHandler()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getExceptionHandler()
     */
    @Override
    public ExceptionHandler getExceptionHandler() {
        return getWrapped().getExceptionHandler();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#setExceptionHandler(ExceptionHandler)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#setExceptionHandler(ExceptionHandler)
     */
    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        getWrapped().setExceptionHandler(exceptionHandler);
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getMessageList()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getMessageList()
     */
    @Override
    public List<FacesMessage> getMessageList() {
        return getWrapped().getMessageList();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getMessageList(String)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getMessageList(String)
     */
    @Override
    public List<FacesMessage> getMessageList(String clientId) {
        return getWrapped().getMessageList(clientId);
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#isPostback()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#isPostback()
     */
    @Override
    public boolean isPostback() {
        return getWrapped().isPostback();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#getCurrentPhaseId()}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#getCurrentPhaseId()
     */
    @Override
    public PhaseId getCurrentPhaseId() {
        return getWrapped().getCurrentPhaseId();
    }

    /**
     * <p>The default behavior of this method is to
     * call {@link FacesContext#setCurrentPhaseId(PhaseId)}
     * on the wrapped {@link FacesContext} object.</p>
     *
     * @see javax.faces.context.FacesContext#setCurrentPhaseId(PhaseId)
     */
    @Override
    public void setCurrentPhaseId(PhaseId currentPhaseId) {
        getWrapped().setCurrentPhaseId(currentPhaseId);
    }
    
}
