/*
 * Decompiled with CFR 0.152.
 */
package me.madhead.aws_junit5.common.v2;

import java.lang.reflect.Field;
import java.net.URI;
import me.madhead.aws_junit5.common.AWSClient;
import me.madhead.aws_junit5.common.AWSEndpoint;
import me.madhead.aws_junit5.common.v2.AWSAdvancedConfiguration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.StringUtils;

public final class AWSClientFactory<S extends AwsClientBuilder<S, T>, T>
implements me.madhead.aws_junit5.common.impl.AWSClientFactory<T> {
    private final AwsClientBuilder<S, T> awsClientBuilder;

    public AWSClientFactory(AwsClientBuilder<S, T> awsClientBuilder) {
        this.awsClientBuilder = awsClientBuilder;
    }

    public T client(Field field) throws Exception {
        AWSClient awsClientAnnotation = field.getAnnotation(AWSClient.class);
        AWSEndpoint endpoint = (AWSEndpoint)awsClientAnnotation.endpoint().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.validate(endpoint);
        AwsClientBuilder awsClientBuilder = ((AwsClientBuilder)this.awsClientBuilder.endpointOverride(new URI(endpoint.url()))).region(Region.of((String)endpoint.region())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)endpoint.accessKey(), (String)endpoint.secretKey())));
        if (field.isAnnotationPresent(AWSAdvancedConfiguration.class)) {
            SdkAsyncHttpClient sdkAsyncHttpClient;
            SdkHttpClient sdkHttpClient;
            AWSAdvancedConfiguration awsAdvancedConfiguration = field.getAnnotation(AWSAdvancedConfiguration.class);
            ClientOverrideConfiguration clientOverrideConfiguration = awsAdvancedConfiguration.clientOverrideConfigurationFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).create();
            if (null != clientOverrideConfiguration) {
                awsClientBuilder.overrideConfiguration(clientOverrideConfiguration);
            }
            if (awsClientBuilder instanceof AwsSyncClientBuilder && null != (sdkHttpClient = awsAdvancedConfiguration.sdkHttpClientFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).create())) {
                ((AwsSyncClientBuilder)awsClientBuilder).httpClient(sdkHttpClient);
            }
            if (awsClientBuilder instanceof AwsAsyncClientBuilder && null != (sdkAsyncHttpClient = awsAdvancedConfiguration.sdkAsyncHttpClientFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).create())) {
                ((AwsAsyncClientBuilder)awsClientBuilder).httpClient(sdkAsyncHttpClient);
            }
        }
        return (T)awsClientBuilder.build();
    }

    private void validate(AWSEndpoint clientConfiguration) {
        if (clientConfiguration.url() == null || StringUtils.isEmpty((CharSequence)clientConfiguration.url())) {
            throw new IllegalArgumentException("Missing URL");
        }
    }
}

