/*
 * Decompiled with CFR 0.152.
 */
package mockit.external.asm;

import mockit.external.asm.AnnotationVisitor;
import mockit.external.asm.AnnotationWriter;
import mockit.external.asm.Attribute;
import mockit.external.asm.ByteVector;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.Edge;
import mockit.external.asm.Handler;
import mockit.external.asm.Item;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;

public final class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    ClassWriter cw;
    private final int access;
    private final int name;
    private final int desc;
    private final String descriptor;
    int classReaderOffset;
    int classReaderLength;
    String signature;
    int exceptionCount;
    int[] exceptions;
    private ByteVector annd;
    private AnnotationWriter anns;
    private AnnotationWriter ianns;
    private AnnotationWriter[] panns;
    private AnnotationWriter[] ipanns;
    private Attribute attrs;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;
    private int catchCount;
    private Handler catchTable;
    private Handler lastHandler;
    private int localVarCount;
    private ByteVector localVar;
    private int localVarTypeCount;
    private ByteVector localVarType;
    private int lineNumberCount;
    private ByteVector lineNumber;
    private Attribute cattrs;
    private boolean resize;
    private final boolean computeMaxs;
    public int stackSize;
    private int maxStackSize;
    public Label currentBlock;
    private Label blockStack;
    private static final int[] SIZE;

    MethodWriter(ClassWriter cw, int access, String name, String desc, String signature, String[] exceptions, boolean computeMaxs) {
        if (cw.firstMethod == null) {
            cw.firstMethod = this;
        } else {
            cw.lastMethod.next = this;
        }
        cw.lastMethod = this;
        this.cw = cw;
        this.access = access;
        this.name = cw.newUTF8(name);
        this.desc = cw.newUTF8(desc);
        this.descriptor = desc;
        this.signature = signature;
        if (exceptions != null && exceptions.length > 0) {
            this.exceptionCount = exceptions.length;
            this.exceptions = new int[this.exceptionCount];
            for (int i = 0; i < this.exceptionCount; ++i) {
                this.exceptions[i] = cw.newClass(exceptions[i]);
            }
        }
        this.computeMaxs = computeMaxs;
        if (computeMaxs) {
            int size = MethodWriter.getArgumentsAndReturnSizes(desc) >> 2;
            if ((access & 8) != 0) {
                --size;
            }
            this.maxLocals = size;
            this.currentBlock = new Label();
            this.currentBlock.pushed = true;
            this.blockStack = this.currentBlock;
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.annd = new ByteVector();
        return new AnnotationWriter(this.cw, false, this.annd, null, 0);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        ByteVector bv = new ByteVector();
        bv.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw = new AnnotationWriter(this.cw, true, bv, bv, 2);
        if (visible) {
            aw.next = this.anns;
            this.anns = aw;
        } else {
            aw.next = this.ianns;
            this.ianns = aw;
        }
        return aw;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        ByteVector bv = new ByteVector();
        bv.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw = new AnnotationWriter(this.cw, true, bv, bv, 2);
        if (visible) {
            if (this.panns == null) {
                this.panns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            aw.next = this.panns[parameter];
            this.panns[parameter] = aw;
        } else {
            if (this.ipanns == null) {
                this.ipanns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            aw.next = this.ipanns[parameter];
            this.ipanns[parameter] = aw;
        }
        return aw;
    }

    public void visitAttribute(Attribute attr) {
        if (attr.isCodeAttribute()) {
            attr.next = this.cattrs;
            this.cattrs = attr;
        } else {
            attr.next = this.attrs;
            this.attrs = attr;
        }
    }

    public void visitCode() {
    }

    public void visitInsn(int opcode) {
        if (this.computeMaxs) {
            int size = this.stackSize + SIZE[opcode];
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
            if ((opcode >= 172 && opcode <= 177 || opcode == 191) && this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.currentBlock = null;
            }
        }
        this.code.putByte(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        if (this.computeMaxs && opcode != 188) {
            int size = this.stackSize + 1;
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        if (opcode == 17) {
            this.code.put12(opcode, operand);
        } else {
            this.code.put11(opcode, operand);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (this.computeMaxs) {
            int n;
            if (opcode == 169) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.currentBlock = null;
                }
            } else {
                int size = this.stackSize + SIZE[opcode];
                if (size > this.maxStackSize) {
                    this.maxStackSize = size;
                }
                this.stackSize = size;
            }
            if ((n = opcode == 22 || opcode == 24 || opcode == 55 || opcode == 57 ? var + 2 : var + 1) > this.maxLocals) {
                this.maxLocals = n;
            }
        }
        if (var < 4 && opcode != 169) {
            int opt = opcode < 54 ? 26 + (opcode - 21 << 2) + var : 59 + (opcode - 54 << 2) + var;
            this.code.putByte(opt);
        } else if (var >= 256) {
            this.code.putByte(196).put12(opcode, var);
        } else {
            this.code.put11(opcode, var);
        }
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (this.computeMaxs && opcode == 187) {
            int size = this.stackSize + 1;
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        this.code.put12(opcode, this.cw.newClass(desc));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.computeMaxs) {
            int size;
            char c = desc.charAt(0);
            switch (opcode) {
                case 178: {
                    size = this.stackSize + (c == 'D' || c == 'J' ? 2 : 1);
                    break;
                }
                case 179: {
                    size = this.stackSize + (c == 'D' || c == 'J' ? -2 : -1);
                    break;
                }
                case 180: {
                    size = this.stackSize + (c == 'D' || c == 'J' ? 1 : 0);
                    break;
                }
                default: {
                    size = this.stackSize + (c == 'D' || c == 'J' ? -3 : -2);
                }
            }
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        this.code.put12(opcode, this.cw.newField(owner, name, desc));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        boolean itf = opcode == 185;
        Item i = this.cw.newMethodItem(owner, name, desc, itf);
        int argSize = i.intVal;
        if (this.computeMaxs) {
            int size;
            if (argSize == 0) {
                i.intVal = argSize = MethodWriter.getArgumentsAndReturnSizes(desc);
            }
            if ((size = opcode == 184 ? this.stackSize - (argSize >> 2) + (argSize & 3) + 1 : this.stackSize - (argSize >> 2) + (argSize & 3)) > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        if (itf) {
            if (!this.computeMaxs && argSize == 0) {
                i.intVal = argSize = MethodWriter.getArgumentsAndReturnSizes(desc);
            }
            this.code.put12(185, i.index).put11(argSize >> 2, 0);
        } else {
            this.code.put12(opcode, i.index);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this.computeMaxs) {
            if (opcode == 167) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.addSuccessor(this.stackSize, label);
                    this.currentBlock = null;
                }
            } else if (opcode == 168) {
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize + 1, label);
                }
            } else {
                this.stackSize += SIZE[opcode];
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize, label);
                }
            }
        }
        if (label.resolved && label.position - this.code.length < Short.MIN_VALUE) {
            if (opcode == 167) {
                this.code.putByte(200);
            } else if (opcode == 168) {
                this.code.putByte(201);
            } else {
                this.code.putByte(opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1);
                this.code.putShort(8);
                this.code.putByte(200);
            }
            label.put(this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(opcode);
            label.put(this.code, this.code.length - 1, false);
        }
    }

    public void visitLabel(Label label) {
        if (this.computeMaxs) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
        }
        this.resize |= label.resolve(this.code.length, this.code.data);
    }

    public void visitLdcInsn(Object cst) {
        Item i = this.cw.newConstItem(cst);
        if (this.computeMaxs) {
            int size = i.type == 5 || i.type == 6 ? this.stackSize + 2 : this.stackSize + 1;
            if (size > this.maxStackSize) {
                this.maxStackSize = size;
            }
            this.stackSize = size;
        }
        int index = i.index;
        if (i.type == 5 || i.type == 6) {
            this.code.put12(20, index);
        } else if (index >= 256) {
            this.code.put12(19, index);
        } else {
            this.code.put11(18, index);
        }
    }

    public void visitIincInsn(int var, int increment) {
        int n;
        if (this.computeMaxs && (n = var + 1) > this.maxLocals) {
            this.maxLocals = n;
        }
        if (var > 255 || increment > 127 || increment < -128) {
            this.code.putByte(196).put12(132, var).putShort(increment);
        } else {
            this.code.putByte(132).put11(var, increment);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, dflt);
                for (int i = 0; i < labels.length; ++i) {
                    this.addSuccessor(this.stackSize, labels[i]);
                }
                this.currentBlock = null;
            }
        }
        int source = this.code.length;
        this.code.putByte(170);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        dflt.put(this.code, source, true);
        this.code.putInt(min).putInt(max);
        for (int i = 0; i < labels.length; ++i) {
            labels[i].put(this.code, source, true);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, dflt);
                for (int i = 0; i < labels.length; ++i) {
                    this.addSuccessor(this.stackSize, labels[i]);
                }
                this.currentBlock = null;
            }
        }
        int source = this.code.length;
        this.code.putByte(171);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        dflt.put(this.code, source, true);
        this.code.putInt(labels.length);
        for (int i = 0; i < labels.length; ++i) {
            this.code.putInt(keys[i]);
            labels[i].put(this.code, source, true);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.computeMaxs) {
            this.stackSize += 1 - dims;
        }
        this.code.put12(197, this.cw.newClass(desc)).putByte(dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.computeMaxs && !handler.pushed) {
            handler.beginStackSize = 1;
            handler.pushed = true;
            handler.next = this.blockStack;
            this.blockStack = handler;
        }
        ++this.catchCount;
        Handler h = new Handler();
        h.start = start;
        h.end = end;
        h.handler = handler;
        h.desc = type;
        int n = h.type = type != null ? this.cw.newClass(type) : 0;
        if (this.lastHandler == null) {
            this.catchTable = h;
        } else {
            this.lastHandler.next = h;
        }
        this.lastHandler = h;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        char c;
        int n;
        if (signature != null) {
            if (this.localVarType == null) {
                this.localVarType = new ByteVector();
            }
            ++this.localVarTypeCount;
            this.localVarType.putShort(start.position).putShort(end.position - start.position).putShort(this.cw.newUTF8(name)).putShort(this.cw.newUTF8(signature)).putShort(index);
        }
        if (this.localVar == null) {
            this.localVar = new ByteVector();
        }
        ++this.localVarCount;
        this.localVar.putShort(start.position).putShort(end.position - start.position).putShort(this.cw.newUTF8(name)).putShort(this.cw.newUTF8(desc)).putShort(index);
        if (this.computeMaxs && (n = index + ((c = desc.charAt(0)) == 'L' || c == 'D' ? 2 : 1)) > this.maxLocals) {
            this.maxLocals = n;
        }
    }

    public void visitLineNumber(int line, Label start) {
        if (this.lineNumber == null) {
            this.lineNumber = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumber.putShort(start.position);
        this.lineNumber.putShort(line);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.computeMaxs) {
            int max = 0;
            Label stack = this.blockStack;
            while (stack != null) {
                Label l = stack;
                stack = stack.next;
                int start = l.beginStackSize;
                int blockMax = start + l.maxStackSize;
                if (blockMax > max) {
                    max = blockMax;
                }
                Edge b = l.successors;
                while (b != null) {
                    l = b.successor;
                    if (!l.pushed) {
                        l.beginStackSize = start + b.stackSize;
                        l.pushed = true;
                        l.next = stack;
                        stack = l;
                    }
                    b = b.next;
                }
            }
            this.maxStack = max;
        } else {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
        }
    }

    public void visitEnd() {
    }

    private static int getArgumentsAndReturnSizes(String desc) {
        int n = 1;
        int c = 1;
        while (true) {
            char car;
            if ((car = desc.charAt(c++)) == ')') {
                car = desc.charAt(c);
                return n << 2 | (car == 'V' ? 0 : (car == 'D' || car == 'J' ? 2 : 1));
            }
            if (car == 'L') {
                while (desc.charAt(c++) != ';') {
                }
                ++n;
                continue;
            }
            if (car == '[') {
                while ((car = desc.charAt(c)) == '[') {
                    ++c;
                }
                if (car != 'D' && car != 'J') continue;
                --n;
                continue;
            }
            if (car == 'D' || car == 'J') {
                n += 2;
                continue;
            }
            ++n;
        }
    }

    private void addSuccessor(int stackSize, Label successor) {
        Edge b = new Edge();
        b.stackSize = stackSize;
        b.successor = successor;
        b.next = this.currentBlock.successors;
        this.currentBlock.successors = b;
    }

    int getSize() {
        int i;
        if (this.classReaderOffset != 0) {
            return 6 + this.classReaderLength;
        }
        if (this.resize) {
            this.resizeInstructions(new int[0], new int[0], 0);
        }
        int size = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            size += 18 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                this.cw.newUTF8("LocalVariableTable");
                size += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                this.cw.newUTF8("LocalVariableTypeTable");
                size += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                this.cw.newUTF8("LineNumberTable");
                size += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                size += this.cattrs.getSize(this.cw);
            }
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            size += 8 + 2 * this.exceptionCount;
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            this.cw.newUTF8("Synthetic");
            size += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            size += 6;
        }
        if (this.cw.version == 48) {
            if ((this.access & 0x80) != 0) {
                this.cw.newUTF8("Varargs");
                size += 6;
            }
            if ((this.access & 0x40) != 0) {
                this.cw.newUTF8("Bridge");
                size += 6;
            }
        }
        if (this.signature != null) {
            this.cw.newUTF8("Signature");
            this.cw.newUTF8(this.signature);
            size += 8;
        }
        if (this.annd != null) {
            this.cw.newUTF8("AnnotationDefault");
            size += 6 + this.annd.length;
        }
        if (this.anns != null) {
            this.cw.newUTF8("RuntimeVisibleAnnotations");
            size += 8 + this.anns.getSize();
        }
        if (this.ianns != null) {
            this.cw.newUTF8("RuntimeInvisibleAnnotations");
            size += 8 + this.ianns.getSize();
        }
        if (this.panns != null) {
            this.cw.newUTF8("RuntimeVisibleParameterAnnotations");
            size += 7 + 2 * this.panns.length;
            for (i = this.panns.length - 1; i >= 0; --i) {
                size += this.panns[i] == null ? 0 : this.panns[i].getSize();
            }
        }
        if (this.ipanns != null) {
            this.cw.newUTF8("RuntimeInvisibleParameterAnnotations");
            size += 7 + 2 * this.ipanns.length;
            for (i = this.ipanns.length - 1; i >= 0; --i) {
                size += this.ipanns[i] == null ? 0 : this.ipanns[i].getSize();
            }
        }
        if (this.attrs != null) {
            size += this.attrs.getSize(this.cw);
        }
        return size;
    }

    void put(ByteVector out) {
        out.putShort(this.access).putShort(this.name).putShort(this.desc);
        if (this.classReaderOffset != 0) {
            out.putByteArray(this.cw.cr.b, this.classReaderOffset, this.classReaderLength);
            return;
        }
        int attributeCount = 0;
        if (this.code.length > 0) {
            ++attributeCount;
        }
        if (this.exceptionCount > 0) {
            ++attributeCount;
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            ++attributeCount;
        }
        if ((this.access & 0x20000) != 0) {
            ++attributeCount;
        }
        if (this.cw.version == 48) {
            if ((this.access & 0x80) != 0) {
                ++attributeCount;
            }
            if ((this.access & 0x40) != 0) {
                ++attributeCount;
            }
        }
        if (this.signature != null) {
            ++attributeCount;
        }
        if (this.annd != null) {
            ++attributeCount;
        }
        if (this.anns != null) {
            ++attributeCount;
        }
        if (this.ianns != null) {
            ++attributeCount;
        }
        if (this.panns != null) {
            ++attributeCount;
        }
        if (this.ipanns != null) {
            ++attributeCount;
        }
        if (this.attrs != null) {
            attributeCount += this.attrs.getCount();
        }
        out.putShort(attributeCount);
        if (this.code.length > 0) {
            int size = 12 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                size += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                size += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                size += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                size += this.cattrs.getSize(this.cw);
            }
            out.putShort(this.cw.newUTF8("Code")).putInt(size);
            out.putShort(this.maxStack).putShort(this.maxLocals);
            out.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            out.putShort(this.catchCount);
            if (this.catchCount > 0) {
                Handler h = this.catchTable;
                while (h != null) {
                    out.putShort(h.start.position).putShort(h.end.position).putShort(h.handler.position).putShort(h.type);
                    h = h.next;
                }
            }
            attributeCount = 0;
            if (this.localVar != null) {
                ++attributeCount;
            }
            if (this.localVarType != null) {
                ++attributeCount;
            }
            if (this.lineNumber != null) {
                ++attributeCount;
            }
            if (this.cattrs != null) {
                attributeCount += this.cattrs.getCount();
            }
            out.putShort(attributeCount);
            if (this.localVar != null) {
                out.putShort(this.cw.newUTF8("LocalVariableTable"));
                out.putInt(this.localVar.length + 2).putShort(this.localVarCount);
                out.putByteArray(this.localVar.data, 0, this.localVar.length);
            }
            if (this.localVarType != null) {
                out.putShort(this.cw.newUTF8("LocalVariableTypeTable"));
                out.putInt(this.localVarType.length + 2).putShort(this.localVarTypeCount);
                out.putByteArray(this.localVarType.data, 0, this.localVarType.length);
            }
            if (this.lineNumber != null) {
                out.putShort(this.cw.newUTF8("LineNumberTable"));
                out.putInt(this.lineNumber.length + 2).putShort(this.lineNumberCount);
                out.putByteArray(this.lineNumber.data, 0, this.lineNumber.length);
            }
            if (this.cattrs != null) {
                this.cattrs.put(this.cw, out);
            }
        }
        if (this.exceptionCount > 0) {
            out.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            out.putShort(this.exceptionCount);
            for (int i = 0; i < this.exceptionCount; ++i) {
                out.putShort(this.exceptions[i]);
            }
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            out.putShort(this.cw.newUTF8("Synthetic")).putInt(0);
        }
        if ((this.access & 0x20000) != 0) {
            out.putShort(this.cw.newUTF8("Deprecated")).putInt(0);
        }
        if (this.cw.version == 48) {
            if ((this.access & 0x80) != 0) {
                out.putShort(this.cw.newUTF8("Varargs")).putInt(0);
            }
            if ((this.access & 0x40) != 0) {
                out.putShort(this.cw.newUTF8("Bridge")).putInt(0);
            }
        }
        if (this.signature != null) {
            out.putShort(this.cw.newUTF8("Signature")).putInt(2).putShort(this.cw.newUTF8(this.signature));
        }
        if (this.annd != null) {
            out.putShort(this.cw.newUTF8("AnnotationDefault"));
            out.putInt(this.annd.length);
            out.putByteArray(this.annd.data, 0, this.annd.length);
        }
        if (this.anns != null) {
            out.putShort(this.cw.newUTF8("RuntimeVisibleAnnotations"));
            this.anns.put(out);
        }
        if (this.ianns != null) {
            out.putShort(this.cw.newUTF8("RuntimeInvisibleAnnotations"));
            this.ianns.put(out);
        }
        if (this.panns != null) {
            out.putShort(this.cw.newUTF8("RuntimeVisibleParameterAnnotations"));
            AnnotationWriter.put(this.panns, out);
        }
        if (this.ipanns != null) {
            out.putShort(this.cw.newUTF8("RuntimeInvisibleParameterAnnotations"));
            AnnotationWriter.put(this.ipanns, out);
        }
        if (this.attrs != null) {
            this.attrs.put(this.cw, out);
        }
    }

    private int[] resizeInstructions(int[] indexes, int[] sizes, int len) {
        int i;
        int newOffset;
        int label;
        int u;
        byte[] b = this.code.data;
        int[] allIndexes = new int[len];
        int[] allSizes = new int[len];
        System.arraycopy(indexes, 0, allIndexes, 0, len);
        System.arraycopy(sizes, 0, allSizes, 0, len);
        boolean[] resize = new boolean[this.code.length];
        int state = 3;
        do {
            if (state == 3) {
                state = 2;
            }
            u = 0;
            while (u < b.length) {
                int opcode = b[u] & 0xFF;
                int insert = 0;
                switch (ClassWriter.TYPE[opcode]) {
                    case 0: 
                    case 4: {
                        ++u;
                        break;
                    }
                    case 8: {
                        if (opcode > 201) {
                            opcode = opcode < 218 ? opcode - 49 : opcode - 20;
                            label = u + MethodWriter.readUnsignedShort(b, u + 1);
                        } else {
                            label = u + MethodWriter.readShort(b, u + 1);
                        }
                        newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, u, label);
                        if (!(newOffset >= Short.MIN_VALUE && newOffset <= Short.MAX_VALUE || resize[u])) {
                            insert = opcode == 167 || opcode == 168 ? 2 : 5;
                            resize[u] = true;
                        }
                        u += 3;
                        break;
                    }
                    case 9: {
                        u += 5;
                        break;
                    }
                    case 13: {
                        if (state == 1) {
                            newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, u);
                            insert = -(newOffset & 3);
                        } else if (!resize[u]) {
                            insert = u & 3;
                            resize[u] = true;
                        }
                        u = u + 4 - (u & 3);
                        u += 4 * (MethodWriter.readInt(b, u + 8) - MethodWriter.readInt(b, u + 4) + 1) + 12;
                        break;
                    }
                    case 14: {
                        if (state == 1) {
                            newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, u);
                            insert = -(newOffset & 3);
                        } else if (!resize[u]) {
                            insert = u & 3;
                            resize[u] = true;
                        }
                        u = u + 4 - (u & 3);
                        u += 8 * MethodWriter.readInt(b, u + 4) + 8;
                        break;
                    }
                    case 16: {
                        opcode = b[u + 1] & 0xFF;
                        if (opcode == 132) {
                            u += 6;
                            break;
                        }
                        u += 4;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 10: {
                        u += 2;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        u += 3;
                        break;
                    }
                    case 7: {
                        u += 5;
                        break;
                    }
                    default: {
                        u += 4;
                    }
                }
                if (insert == 0) continue;
                int[] newIndexes = new int[allIndexes.length + 1];
                int[] newSizes = new int[allSizes.length + 1];
                System.arraycopy(allIndexes, 0, newIndexes, 0, allIndexes.length);
                System.arraycopy(allSizes, 0, newSizes, 0, allSizes.length);
                newIndexes[allIndexes.length] = u;
                newSizes[allSizes.length] = insert;
                allIndexes = newIndexes;
                allSizes = newSizes;
                if (insert <= 0) continue;
                state = 3;
            }
            if (state >= 3) continue;
            --state;
        } while (state != 0);
        ByteVector newCode = new ByteVector(this.code.length);
        u = 0;
        block24: while (u < this.code.length) {
            for (i = allIndexes.length - 1; i >= 0; --i) {
                if (allIndexes[i] != u || i >= len) continue;
                if (sizes[i] > 0) {
                    newCode.putByteArray(null, 0, sizes[i]);
                } else {
                    newCode.length += sizes[i];
                }
                indexes[i] = newCode.length;
            }
            int opcode = b[u] & 0xFF;
            switch (ClassWriter.TYPE[opcode]) {
                case 0: 
                case 4: {
                    newCode.putByte(opcode);
                    ++u;
                    continue block24;
                }
                case 8: {
                    if (opcode > 201) {
                        opcode = opcode < 218 ? opcode - 49 : opcode - 20;
                        label = u + MethodWriter.readUnsignedShort(b, u + 1);
                    } else {
                        label = u + MethodWriter.readShort(b, u + 1);
                    }
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, u, label);
                    if (resize[u]) {
                        if (opcode == 167) {
                            newCode.putByte(200);
                        } else if (opcode == 168) {
                            newCode.putByte(201);
                        } else {
                            newCode.putByte(opcode <= 166 ? (opcode + 1 ^ 1) - 1 : opcode ^ 1);
                            newCode.putShort(8);
                            newCode.putByte(200);
                            newOffset -= 3;
                        }
                        newCode.putInt(newOffset);
                    } else {
                        newCode.putByte(opcode);
                        newCode.putShort(newOffset);
                    }
                    u += 3;
                    continue block24;
                }
                case 9: {
                    label = u + MethodWriter.readInt(b, u + 1);
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, u, label);
                    newCode.putByte(opcode);
                    newCode.putInt(newOffset);
                    u += 5;
                    continue block24;
                }
                case 13: {
                    int v = u;
                    u = u + 4 - (v & 3);
                    newCode.putByte(170);
                    while (newCode.length % 4 != 0) {
                        newCode.putByte(0);
                    }
                    label = v + MethodWriter.readInt(b, u);
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v, label);
                    newCode.putInt(newOffset);
                    int j = MethodWriter.readInt(b, u += 4);
                    newCode.putInt(j);
                    newCode.putInt(MethodWriter.readInt(b, (u += 4) - 4));
                    for (j = MethodWriter.readInt(b, u += 4) - j + 1; j > 0; --j) {
                        label = v + MethodWriter.readInt(b, u);
                        u += 4;
                        newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v, label);
                        newCode.putInt(newOffset);
                    }
                    continue block24;
                }
                case 14: {
                    int j;
                    int v = u;
                    u = u + 4 - (v & 3);
                    newCode.putByte(171);
                    while (newCode.length % 4 != 0) {
                        newCode.putByte(0);
                    }
                    label = v + MethodWriter.readInt(b, u);
                    newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v, label);
                    newCode.putInt(newOffset);
                    u += 4;
                    newCode.putInt(j);
                    for (j = MethodWriter.readInt(b, u += 4); j > 0; --j) {
                        newCode.putInt(MethodWriter.readInt(b, u));
                        label = v + MethodWriter.readInt(b, u += 4);
                        u += 4;
                        newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, v, label);
                        newCode.putInt(newOffset);
                    }
                    continue block24;
                }
                case 16: {
                    opcode = b[u + 1] & 0xFF;
                    if (opcode == 132) {
                        newCode.putByteArray(b, u, 6);
                        u += 6;
                        continue block24;
                    }
                    newCode.putByteArray(b, u, 4);
                    u += 4;
                    continue block24;
                }
                case 1: 
                case 3: 
                case 10: {
                    newCode.putByteArray(b, u, 2);
                    u += 2;
                    continue block24;
                }
                case 2: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    newCode.putByteArray(b, u, 3);
                    u += 3;
                    continue block24;
                }
                case 7: {
                    newCode.putByteArray(b, u, 5);
                    u += 5;
                    continue block24;
                }
            }
            newCode.putByteArray(b, u, 4);
            u += 4;
        }
        Handler h = this.catchTable;
        while (h != null) {
            MethodWriter.getNewOffset(allIndexes, allSizes, h.start);
            MethodWriter.getNewOffset(allIndexes, allSizes, h.end);
            MethodWriter.getNewOffset(allIndexes, allSizes, h.handler);
            h = h.next;
        }
        for (i = 0; i < 2; ++i) {
            ByteVector bv;
            ByteVector byteVector = bv = i == 0 ? this.localVar : this.localVarType;
            if (bv == null) continue;
            b = bv.data;
            for (u = 0; u < bv.length; u += 10) {
                label = MethodWriter.readUnsignedShort(b, u);
                newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, label);
                MethodWriter.writeShort(b, u, newOffset);
                newOffset = MethodWriter.getNewOffset(allIndexes, allSizes, 0, label += MethodWriter.readUnsignedShort(b, u + 2)) - newOffset;
                MethodWriter.writeShort(b, u + 2, newOffset);
            }
        }
        if (this.lineNumber != null) {
            b = this.lineNumber.data;
            for (u = 0; u < this.lineNumber.length; u += 4) {
                MethodWriter.writeShort(b, u, MethodWriter.getNewOffset(allIndexes, allSizes, 0, MethodWriter.readUnsignedShort(b, u)));
            }
        }
        while (this.cattrs != null) {
            Label[] labels = this.cattrs.getLabels();
            if (labels == null) continue;
            for (i = labels.length - 1; i >= 0; --i) {
                if (labels[i].resized) continue;
                labels[i].position = MethodWriter.getNewOffset(allIndexes, allSizes, 0, labels[i].position);
                labels[i].resized = true;
            }
        }
        this.code = newCode;
        return indexes;
    }

    static int readUnsignedShort(byte[] b, int index) {
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    static short readShort(byte[] b, int index) {
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    static int readInt(byte[] b, int index) {
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    static void writeShort(byte[] b, int index, int s) {
        b[index] = (byte)(s >>> 8);
        b[index + 1] = (byte)s;
    }

    static int getNewOffset(int[] indexes, int[] sizes, int begin, int end) {
        int offset = end - begin;
        for (int i = 0; i < indexes.length; ++i) {
            if (begin < indexes[i] && indexes[i] <= end) {
                offset += sizes[i];
                continue;
            }
            if (end >= indexes[i] || indexes[i] > begin) continue;
            offset -= sizes[i];
        }
        return offset;
    }

    static void getNewOffset(int[] indexes, int[] sizes, Label label) {
        if (!label.resized) {
            label.position = MethodWriter.getNewOffset(indexes, sizes, 0, label.position);
            label.resized = true;
        }
    }

    static {
        int[] b = new int[202];
        String s = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i = 0; i < b.length; ++i) {
            b[i] = s.charAt(i) - 69;
        }
        SIZE = b;
    }
}

