/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration;

import java.lang.reflect.Method;
import mockit.Capturing;
import mockit.Mockit;
import mockit.UsingMocksAndStubs;
import mockit.internal.capturing.CaptureOfImplementationsForTestClass;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.mocking.SharedFieldTypeRedefinitions;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunnerDecorator {
    protected final void updateTestClassState(Object target, Class<?> testClass) {
        try {
            this.handleSwitchToNewTestClassIfApplicable(testClass);
            if (target != null) {
                this.handleMockFieldsForWholeTestClass(target);
            }
        }
        catch (Error e) {
            SavePoint.rollbackForTestClass();
            throw e;
        }
        catch (RuntimeException e) {
            SavePoint.rollbackForTestClass();
            throw e;
        }
    }

    private void handleSwitchToNewTestClassIfApplicable(Class<?> testClass) {
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (testClass != currentTestClass) {
            if (currentTestClass == null) {
                SavePoint.registerNewActiveSavePoint();
            } else if (!currentTestClass.isAssignableFrom(testClass)) {
                TestRunnerDecorator.cleanUpMocksFromPreviousTestClass();
                SavePoint.registerNewActiveSavePoint();
            }
            this.applyClassLevelMockingIfSpecifiedForTestClass(testClass);
            TestRun.setCurrentTestClass(testClass);
        }
    }

    public static void cleanUpMocksFromPreviousTestClass() {
        SharedFieldTypeRedefinitions redefinitions;
        SavePoint.rollbackForTestClass();
        CaptureOfImplementationsForTestClass capture = TestRun.getCaptureOfSubtypes();
        if (capture != null) {
            capture.cleanUp();
            TestRun.setCaptureOfSubtypes(null);
        }
        if ((redefinitions = TestRun.getSharedFieldTypeRedefinitions()) != null) {
            redefinitions.cleanUp();
            TestRun.setSharedFieldTypeRedefinitions(null);
        }
    }

    private void applyClassLevelMockingIfSpecifiedForTestClass(Class<?> testClass) {
        this.setUpClassLevelMocksAndStubs(testClass);
        this.setUpClassLevelCapturing(testClass);
    }

    protected final void setUpClassLevelMocksAndStubs(Class<?> testClass) {
        UsingMocksAndStubs mocksAndStubs = testClass.getAnnotation(UsingMocksAndStubs.class);
        if (mocksAndStubs != null) {
            Mockit.setUpMocksAndStubs(mocksAndStubs.value());
        }
    }

    private void setUpClassLevelCapturing(Class<?> testClass) {
        Capturing capturingType = testClass.getAnnotation(Capturing.class);
        if (capturingType != null) {
            CaptureOfImplementationsForTestClass capture = new CaptureOfImplementationsForTestClass();
            capture.makeSureAllSubtypesAreModified(null, capturingType);
            TestRun.setCaptureOfSubtypes(capture);
        }
    }

    private void handleMockFieldsForWholeTestClass(Object target) {
        SharedFieldTypeRedefinitions sharedRedefinitions = TestRun.getSharedFieldTypeRedefinitions();
        if (sharedRedefinitions == null) {
            sharedRedefinitions = new SharedFieldTypeRedefinitions(target);
            sharedRedefinitions.redefineTypesForTestClass();
            TestRun.setSharedFieldTypeRedefinitions(sharedRedefinitions);
        } else {
            sharedRedefinitions.cleanUp();
            sharedRedefinitions.redefineTypesForTestClass();
        }
        if (target != TestRun.getCurrentTestInstance()) {
            sharedRedefinitions.assignNewInstancesToMockFields(target);
        }
    }

    protected final Object[] createInstancesForMockParametersIfAny(Object target, Method testMethod, Object[] params) {
        if (testMethod.getParameterTypes().length == 0) {
            return params;
        }
        ParameterTypeRedefinitions redefinitions = new ParameterTypeRedefinitions(target, testMethod);
        ExecutingTest executingTest = TestRun.getExecutingTest();
        executingTest.setParameterTypeRedefinitions(redefinitions);
        return redefinitions.getParameterValues();
    }
}

