/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit4.internal;

import java.lang.reflect.Method;
import java.util.List;
import mockit.Mock;
import mockit.MockClass;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MockClass(realClass=FrameworkMethod.class)
public final class BlockJUnit4ClassRunnerDecorator
extends TestRunnerDecorator {
    public FrameworkMethod it;
    private boolean generateTestIdForNextBeforeMethod;

    @Mock(reentrant=true)
    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        Class<?> testClass;
        Method method = this.it.getMethod();
        Class<?> clazz = testClass = target == null ? method.getDeclaringClass() : target.getClass();
        if (testClass.isAnnotationPresent(Suite.SuiteClasses.class)) {
            this.setUpClassLevelMocksAndStubs(testClass);
        } else {
            this.updateTestClassState(target, testClass);
        }
        if (this.it.getAnnotation(Test.class) == null) {
            if (this.generateTestIdForNextBeforeMethod && this.it.getAnnotation(Before.class) != null) {
                TestRun.generateIdForNextTest();
                this.generateTestIdForNextBeforeMethod = false;
            }
            TestRun.setRunningIndividualTest(target);
            TestRun.setRunningTestMethod(null);
            try {
                Object object = this.it.invokeExplosively(target, params);
                return object;
            }
            catch (Throwable t) {
                RecordAndReplayExecution.endCurrentReplayIfAny();
                Utilities.filterStackTrace(t);
                throw t;
            }
            finally {
                TestRun.setRunningIndividualTest(null);
            }
        }
        if (this.generateTestIdForNextBeforeMethod) {
            TestRun.generateIdForNextTest();
        }
        TestRun.setRunningTestMethod(method);
        this.generateTestIdForNextBeforeMethod = true;
        try {
            this.executeTest(target, params);
            Object t = null;
            return t;
        }
        catch (Throwable t) {
            Utilities.filterStackTrace(t);
            throw t;
        }
        finally {
            TestRun.finishCurrentTestExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(Object target, Object ... params) throws Throwable {
        SavePoint savePoint = new SavePoint();
        boolean nothingThrownByTest = false;
        try {
            params = this.createInstancesForMockParametersIfAny(target, this.it.getMethod(), params);
            TestRun.setRunningIndividualTest(target);
            this.it.invokeExplosively(target, params);
            nothingThrownByTest = true;
        }
        finally {
            TestRun.enterNoMockingZone();
            AssertionError expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
            try {
                if (nothingThrownByTest && expectationsFailure == null) {
                    TestRun.verifyExpectationsOnAnnotatedMocks();
                }
            }
            finally {
                TestRun.resetExpectationsOnAnnotatedMocks();
                savePoint.rollback();
                TestRun.exitNoMockingZone();
            }
            if (nothingThrownByTest && expectationsFailure != null) {
                throw expectationsFailure;
            }
        }
    }

    @Mock(reentrant=true)
    public void validatePublicVoidNoArg(boolean isStatic, List<Throwable> errors) {
        if (!isStatic && this.it.getMethod().getParameterTypes().length > 0) {
            this.it.validatePublicVoid(false, errors);
            return;
        }
        this.it.validatePublicVoidNoArg(isStatic, errors);
    }
}

