/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import mockit.Expectations;
import mockit.NonStrictExpectations;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.FailureState;
import mockit.internal.expectations.OrderedVerificationPhase;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.PhasedExecutionState;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.ReplayPhase;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.UnorderedVerificationPhase;
import mockit.internal.expectations.VerificationPhase;
import mockit.internal.expectations.mocking.CaptureOfNewInstancesForParameters;
import mockit.internal.expectations.mocking.DynamicPartialMocking;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.expectations.mocking.LocalFieldTypeRedefinitions;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.mocking.SharedFieldTypeRedefinitions;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecordAndReplayExecution {
    public static final ReentrantLock LOCK = new ReentrantLock();
    private final LocalFieldTypeRedefinitions redefinitions;
    private final Map<Type, Object> typesAndTargetObjects;
    private final DynamicPartialMocking dynamicPartialMocking;
    final PhasedExecutionState executionState;
    final int lastExpectationIndexInPreviousReplayPhase;
    final FailureState failureState = new FailureState();
    private RecordPhase recordPhase;
    private ReplayPhase replayPhase;
    private VerificationPhase verificationPhase;

    public RecordAndReplayExecution(RecordAndReplayExecution previous) {
        if (previous == null) {
            this.executionState = new PhasedExecutionState();
            this.lastExpectationIndexInPreviousReplayPhase = 0;
        } else {
            this.executionState = previous.executionState;
            this.lastExpectationIndexInPreviousReplayPhase = previous.getLastExpectationIndexInPreviousReplayPhase();
        }
        this.redefinitions = null;
        this.typesAndTargetObjects = new HashMap<Type, Object>(1);
        this.dynamicPartialMocking = null;
        this.validateRecordingContext();
        this.validateThereIsAtLeastOneMockedTypeInScope();
        this.discoverDuplicateMockedTypesForAutomaticMockInstanceMatching();
        this.replayPhase = new ReplayPhase(this);
    }

    private int getLastExpectationIndexInPreviousReplayPhase() {
        return this.replayPhase == null ? -1 : this.replayPhase.currentStrictExpectationIndex;
    }

    private void validateRecordingContext() {
        if (TestRun.getSharedFieldTypeRedefinitions() == null) {
            String msg = Startup.wasInitializedOnDemand() ? "JMockit wasn't properly initialized; check that jmockit.jar precedes junit.jar in the classpath (if using JUnit; if not, check the documentation)" : "Invalid context for the recording of expectations";
            throw new IllegalStateException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordAndReplayExecution(Expectations targetObject, Object ... classesOrInstancesToBePartiallyMocked) {
        TestRun.enterNoMockingZone();
        TestRun.getExecutingTest().setShouldIgnoreMockingCallbacks(true);
        try {
            RecordAndReplayExecution previous = TestRun.getExecutingTest().setRecordAndReplay(null);
            Class<?> enclosingClassForTargetObject = targetObject.getClass().getEnclosingClass();
            if (enclosingClassForTargetObject == null) {
                throw new RuntimeException("Invalid top level Expectations subclass");
            }
            if (previous == null) {
                this.executionState = new PhasedExecutionState();
                this.lastExpectationIndexInPreviousReplayPhase = 0;
            } else {
                this.executionState = previous.executionState;
                this.lastExpectationIndexInPreviousReplayPhase = previous.getLastExpectationIndexInPreviousReplayPhase();
            }
            this.recordPhase = new RecordPhase(this, targetObject instanceof NonStrictExpectations);
            LocalFieldTypeRedefinitions redefs = new LocalFieldTypeRedefinitions(targetObject);
            this.typesAndTargetObjects = previous == null ? new HashMap(2) : previous.typesAndTargetObjects;
            this.redefineFieldTypes(redefs);
            this.redefinitions = redefs.getTypesRedefined() == 0 ? null : redefs;
            this.dynamicPartialMocking = this.applyDynamicPartialMocking(classesOrInstancesToBePartiallyMocked);
            this.validateRecordingContext();
            this.validateThereIsAtLeastOneMockedTypeInScope();
            this.discoverDuplicateMockedTypesForAutomaticMockInstanceMatching();
            TestRun.getExecutingTest().setRecordAndReplay(this);
        }
        finally {
            TestRun.getExecutingTest().setShouldIgnoreMockingCallbacks(false);
            TestRun.exitNoMockingZone();
        }
    }

    private void redefineFieldTypes(LocalFieldTypeRedefinitions redefs) {
        try {
            redefs.redefineTypesForNestedClass(this.typesAndTargetObjects);
        }
        catch (Error e) {
            redefs.cleanUp();
            Utilities.filterStackTrace(e);
            throw e;
        }
        catch (RuntimeException e) {
            redefs.cleanUp();
            Utilities.filterStackTrace(e);
            throw e;
        }
    }

    private void validateThereIsAtLeastOneMockedTypeInScope() {
        ParameterTypeRedefinitions paramTypeRedefinitions;
        if (this.redefinitions == null && this.dynamicPartialMocking == null && TestRun.getSharedFieldTypeRedefinitions().getTypesRedefined() == 0 && ((paramTypeRedefinitions = TestRun.getExecutingTest().getParameterTypeRedefinitions()) == null || paramTypeRedefinitions.getTypesRedefined() == 0)) {
            throw new IllegalStateException("No mocked types in scope; please declare mock fields or parameters for the types you need mocked");
        }
    }

    private void discoverDuplicateMockedTypesForAutomaticMockInstanceMatching() {
        ParameterTypeRedefinitions paramTypeRedefinitions;
        List<Class<?>> fields = TestRun.getSharedFieldTypeRedefinitions().getTargetClasses();
        ArrayList targetClasses = new ArrayList(fields);
        if (this.redefinitions != null) {
            targetClasses.addAll(this.redefinitions.getTargetClasses());
        }
        if ((paramTypeRedefinitions = TestRun.getExecutingTest().getParameterTypeRedefinitions()) != null) {
            targetClasses.addAll(paramTypeRedefinitions.getTargetClasses());
        }
        if (this.dynamicPartialMocking != null) {
            this.addDynamicallyMockedTargetClasses(targetClasses);
        }
        this.executionState.discoverMockedTypesToMatchOnInstances(targetClasses);
    }

    private void addDynamicallyMockedTargetClasses(List<Class<?>> targetClasses) {
        ArrayList staticallyMockedClasses = new ArrayList(targetClasses);
        List<Class<?>> dynamicallyMockedClasses = this.dynamicPartialMocking.getTargetClasses();
        for (Class<?> dynamicallyMockedClass : dynamicallyMockedClasses) {
            if (staticallyMockedClasses.contains(dynamicallyMockedClass)) continue;
            targetClasses.add(dynamicallyMockedClass);
        }
    }

    public Map<Type, Object> getLocalMocks() {
        return this.typesAndTargetObjects;
    }

    private DynamicPartialMocking applyDynamicPartialMocking(Object ... classesOrInstances) {
        if (classesOrInstances == null || classesOrInstances.length == 0) {
            return null;
        }
        DynamicPartialMocking mocking = new DynamicPartialMocking();
        mocking.redefineTypes(classesOrInstances);
        return mocking;
    }

    public RecordPhase getRecordPhase() {
        if (this.recordPhase == null) {
            throw new IllegalStateException("Not in the recording phase");
        }
        return this.recordPhase;
    }

    AssertionError getErrorThrown() {
        return this.failureState.getErrorThrown();
    }

    void setErrorThrown(AssertionError error) {
        this.failureState.setErrorThrown(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object recordOrReplay(Object mock, int mockAccess, String classDesc, String mockDesc, boolean withRealImpl, Object ... args) throws Throwable {
        if (TestRun.getExecutingTest().isShouldIgnoreMockingCallbacks()) {
            return null;
        }
        LOCK.lock();
        try {
            RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest(true);
            if (mockDesc.startsWith("<init>") && RecordAndReplayExecution.handleCallToConstructor(instance, mock, classDesc)) {
                Object var7_7 = null;
                return var7_7;
            }
            if (instance == null) {
                Object object = DefaultValues.computeForReturnType(mockDesc);
                return object;
            }
            Phase currentPhase = instance.getCurrentPhase();
            instance.failureState.clearErrorThrown();
            Object result = currentPhase.handleInvocation(mock, mockAccess, classDesc, mockDesc, withRealImpl, args);
            instance.failureState.reportErrorThrownIfAny();
            Object object = result;
            return object;
        }
        finally {
            LOCK.unlock();
        }
    }

    private static boolean handleCallToConstructor(RecordAndReplayExecution instance, Object mock, String classDesc) {
        if (TestRun.getCurrentTestInstance() != null) {
            CaptureOfNewInstancesForParameters paramTypeCaptures;
            LocalFieldTypeRedefinitions fieldTypeRedefs;
            LocalFieldTypeRedefinitions localFieldTypeRedefinitions = fieldTypeRedefs = instance == null ? null : instance.redefinitions;
            if (fieldTypeRedefs != null && ((FieldTypeRedefinitions)fieldTypeRedefs).captureNewInstanceForApplicableMockField(mock)) {
                return true;
            }
            ParameterTypeRedefinitions paramTypeRedefinitions = TestRun.getExecutingTest().getParameterTypeRedefinitions();
            if (paramTypeRedefinitions != null && (paramTypeCaptures = paramTypeRedefinitions.getCaptureOfNewInstances()) != null && paramTypeCaptures.captureNewInstanceForApplicableMockParameter(mock)) {
                return true;
            }
            SharedFieldTypeRedefinitions sharedFieldTypeRedefs = TestRun.getSharedFieldTypeRedefinitions();
            if (((FieldTypeRedefinitions)sharedFieldTypeRedefs).captureNewInstanceForApplicableMockField(mock)) {
                return true;
            }
        }
        return RecordAndReplayExecution.isCallToSuperClassConstructor(mock, classDesc);
    }

    private static boolean isCallToSuperClassConstructor(Object mock, String calledClassDesc) {
        Class<?> mockedClass = mock.getClass();
        if (mockedClass.isAnonymousClass() && (mockedClass = mockedClass.getSuperclass()) == Object.class) {
            return false;
        }
        String calledClassName = calledClassDesc.replace('/', '.');
        return !calledClassName.equals(mockedClass.getName());
    }

    private Phase getCurrentPhase() {
        ReplayPhase replay = this.replayPhase;
        if (replay == null) {
            return this.recordPhase;
        }
        VerificationPhase verification = this.verificationPhase;
        if (verification == null) {
            if (this.failureState.getErrorThrown() != null) {
                throw this.failureState.getErrorThrown();
            }
            return replay;
        }
        return verification;
    }

    public void endRecording() {
        if (this.replayPhase == null) {
            this.recordPhase = null;
            this.replayPhase = new ReplayPhase(this);
        }
    }

    public VerificationPhase startVerifications(boolean inOrder) {
        if (this.replayPhase == null) {
            throw new IllegalStateException("Not in the replay phase yet");
        }
        List<Expectation> expectations = this.replayPhase.nonStrictInvocations;
        List<Object[]> invocationArguments = this.replayPhase.nonStrictInvocationArguments;
        this.verificationPhase = inOrder ? new OrderedVerificationPhase(this, expectations, invocationArguments) : new UnorderedVerificationPhase(this, expectations, invocationArguments);
        return this.verificationPhase;
    }

    public static AssertionError endCurrentReplayIfAny() {
        RecordAndReplayExecution instance = TestRun.getRecordAndReplayForRunningTest(false);
        return instance == null ? null : instance.endExecution();
    }

    private AssertionError endExecution() {
        AssertionError error;
        this.endRecording();
        if (this.redefinitions != null) {
            this.redefinitions.cleanUp();
        }
        if ((error = this.replayPhase.endExecution()) == null) {
            error = this.failureState.getErrorThrownInAnotherThreadIfAny(error);
        }
        if (error == null && this.verificationPhase != null) {
            error = this.verificationPhase.endVerification();
            this.verificationPhase = null;
        }
        return error;
    }

    public TestOnlyPhase getCurrentTestOnlyPhase() {
        return this.recordPhase != null ? this.recordPhase : this.verificationPhase;
    }

    public void endInvocations() {
        if (this.verificationPhase == null) {
            this.endRecording();
        } else {
            AssertionError error = this.verificationPhase.endVerification();
            this.verificationPhase = null;
            if (error != null) {
                throw error;
            }
        }
    }
}

