/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import mockit.external.hamcrest.Matcher;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.RecordAndReplayExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestOnlyPhase
extends Phase {
    protected int numberOfIterations = 1;
    protected Object nextInstanceToMatch;
    protected boolean matchInstance;
    protected List<Matcher<?>> argMatchers;

    TestOnlyPhase(RecordAndReplayExecution recordAndReplay) {
        super(recordAndReplay);
    }

    public final void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = numberOfIterations;
    }

    public final void setNextInstanceToMatch(Object nextInstanceToMatch) {
        this.nextInstanceToMatch = nextInstanceToMatch;
    }

    public final void addArgMatcher(Matcher<?> matcher) {
        this.createArgMatchersListIfNeeded();
        this.argMatchers.add(matcher);
    }

    private void createArgMatchersListIfNeeded() {
        if (this.argMatchers == null) {
            this.argMatchers = new ArrayList();
        }
    }

    public final void moveArgMatcher(int originalMatcherIndex, int toIndex) {
        int i = 0;
        int matchersFound = 0;
        while (matchersFound <= originalMatcherIndex) {
            if (this.argMatchers.get(i) != null) {
                ++matchersFound;
            }
            ++i;
        }
        --i;
        while (i < toIndex) {
            this.argMatchers.add(i, null);
            ++i;
        }
    }

    public void setMaxInvocationCount(int maxInvocations) {
        int currentMinimum = this.getCurrentExpectation().constraints.minInvocations / this.numberOfIterations;
        int minInvocations = Math.min(currentMinimum, maxInvocations);
        this.handleInvocationCountConstraint(minInvocations, maxInvocations);
    }

    public abstract void handleInvocationCountConstraint(int var1, int var2);

    public abstract void setCustomErrorMessage(CharSequence var1);

    public abstract void applyHandlerForEachInvocation(Object var1);
}

