/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.expectations.mocking.MockConstructorInfo;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CaptureOfNewInstances
extends CaptureOfImplementations {
    final Map<Class<?>, List<Capture>> baseTypeToCaptures = new HashMap();
    Capture captureFound;
    private MockingConfiguration mockingCfg;
    private MockConstructorInfo mockConstructorInfo;
    private boolean stubOutClassInitialization;

    CaptureOfNewInstances() {
    }

    @Override
    public final ClassWriter createModifier(ClassLoader cl, ClassReader cr, String baseTypeDesc) {
        ExpectationsModifier modifier = new ExpectationsModifier(cl, cr, this.mockingCfg, this.mockConstructorInfo);
        modifier.setStubOutClassInitialization(this.stubOutClassInitialization);
        modifier.setClassNameForInstanceMethods(baseTypeDesc);
        return modifier;
    }

    final void registerCaptureOfNewInstances(MockedType typeMetadata) {
        List<Capture> captures;
        this.mockingCfg = typeMetadata.mockingCfg;
        this.mockConstructorInfo = typeMetadata.mockConstructorInfo;
        this.stubOutClassInitialization = typeMetadata.isClassInitializationToBeStubbedOut();
        Class<?> baseType = typeMetadata.getClassType();
        if (!typeMetadata.isFinalFieldOrParameter()) {
            this.makeSureAllSubtypesAreModified(baseType, typeMetadata.capturing);
        }
        if ((captures = this.baseTypeToCaptures.get(baseType)) == null) {
            captures = new ArrayList<Capture>();
            this.baseTypeToCaptures.put(baseType, captures);
        }
        captures.add(new Capture(typeMetadata));
    }

    final boolean captureNewInstance(Object fieldOwner, Object mock) {
        boolean implementationClassModifiedForCaptureOnly;
        this.captureFound = null;
        Class<?> mockedClass = mock.getClass();
        List<Capture> captures = this.baseTypeToCaptures.get(mockedClass);
        boolean bl = implementationClassModifiedForCaptureOnly = captures == null;
        if (implementationClassModifiedForCaptureOnly && (captures = this.findCaptures(mockedClass)) == null) {
            return false;
        }
        for (Capture capture : captures) {
            if (fieldOwner != null && capture.isInstanceAlreadyCaptured(fieldOwner, mock)) break;
            if (!capture.captureInstance()) continue;
            this.captureFound = capture;
            break;
        }
        return implementationClassModifiedForCaptureOnly;
    }

    private List<Capture> findCaptures(Class<?> mockedClass) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = mockedClass.getInterfaces()) {
            List<Capture> found = this.baseTypeToCaptures.get(anInterface);
            if (found == null) continue;
            return found;
        }
        Class<?> superclass = mockedClass.getSuperclass();
        if (superclass == Object.class) {
            return null;
        }
        List<Capture> found = this.baseTypeToCaptures.get(superclass);
        return found != null ? found : this.findCaptures(superclass);
    }

    @Override
    public final void cleanUp() {
        super.cleanUp();
        this.baseTypeToCaptures.clear();
    }

    static class Capture {
        final MockedType typeMetadata;
        int instancesCaptured;

        private Capture(MockedType typeMetadata) {
            this.typeMetadata = typeMetadata;
        }

        private boolean isInstanceAlreadyCaptured(Object fieldOwner, Object mock) {
            return mock == Utilities.getFieldValue(this.typeMetadata.field, fieldOwner);
        }

        private boolean captureInstance() {
            if (this.instancesCaptured < this.typeMetadata.getMaxInstancesToCapture()) {
                ++this.instancesCaptured;
                return true;
            }
            return false;
        }
    }
}

