/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import mockit.external.asm.Type;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MockConstructorInfo {
    private final Class<?>[] superConstructorParameterTypes;
    private final Object[] superConstructorArgs;

    MockConstructorInfo(Object targetObject, MockedType typeMetadata) {
        String methodName;
        if (typeMetadata != null && (methodName = typeMetadata.getConstructorArgsMethod()).length() > 0) {
            Method m = this.findMethodForConstructorArguments(targetObject.getClass(), methodName);
            this.superConstructorParameterTypes = m.getParameterTypes();
            Object[] defaultArgs = this.getDefaultArgs();
            this.superConstructorArgs = (Object[])Utilities.invoke(targetObject, m, defaultArgs);
            return;
        }
        this.superConstructorParameterTypes = null;
        this.superConstructorArgs = null;
    }

    private Method findMethodForConstructorArguments(Class<?> classOfTargetObject, String methodName) {
        for (Method m : classOfTargetObject.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new IllegalArgumentException("Method for constructor arguments \"" + methodName + "\" not found in class " + classOfTargetObject.getName());
    }

    private Object[] getDefaultArgs() {
        Object[] defaultArgs = new Object[this.superConstructorParameterTypes.length];
        for (int i = 0; i < defaultArgs.length; ++i) {
            defaultArgs[i] = DefaultValues.computeForType(this.superConstructorParameterTypes[i]);
        }
        return defaultArgs;
    }

    boolean isWithSuperConstructor() {
        return this.superConstructorParameterTypes != null;
    }

    Type[] getParameterTypesForSuperConstructor() {
        Type[] paramTypes = new Type[this.superConstructorParameterTypes.length];
        for (int i = 0; i < this.superConstructorParameterTypes.length; ++i) {
            paramTypes[i] = Type.getType(this.superConstructorParameterTypes[i]);
        }
        return paramTypes;
    }

    Object[] getSuperConstructorArguments() {
        return this.superConstructorArgs;
    }

    Object newInstance(Class<?> mockedClass) {
        Constructor<?> constructor = mockedClass.getDeclaredConstructors()[0];
        return this.superConstructorParameterTypes == null ? Utilities.invoke(constructor, new Object[0]) : Utilities.invoke(constructor, new Object[]{this.superConstructorArgs});
    }
}

