/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import mockit.Capturing;
import mockit.Cascading;
import mockit.Mocked;
import mockit.NonStrict;
import mockit.internal.expectations.mocking.MockConstructorInfo;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MockedType {
    @Mocked
    private static final Object DUMMY = null;
    private static final int DUMMY_HASHCODE;
    private static final boolean STUB_OUT_STATIC_INITIALIZERS;
    final Field field;
    final boolean fieldFromTestClass;
    private final int accessModifiers;
    private final Mocked mocked;
    final Capturing capturing;
    final Cascading cascading;
    final boolean nonStrict;
    final Type declaredType;
    final String mockId;
    MockingConfiguration mockingCfg;
    MockConstructorInfo mockConstructorInfo;

    MockedType(Field field, boolean fromTestClass) {
        this.field = field;
        this.fieldFromTestClass = fromTestClass;
        this.accessModifiers = field.getModifiers();
        this.mocked = field.getAnnotation(Mocked.class);
        this.capturing = field.getAnnotation(Capturing.class);
        this.cascading = field.getAnnotation(Cascading.class);
        this.nonStrict = field.isAnnotationPresent(NonStrict.class);
        this.declaredType = field.getGenericType();
        this.mockId = field.getName();
        this.registerCascadingIfSpecified();
    }

    private void registerCascadingIfSpecified() {
        if (this.cascading != null) {
            String mockedTypeDesc = this.getClassType().getName().replace('.', '/');
            TestRun.getExecutingTest().addCascadingType(mockedTypeDesc);
        }
    }

    MockedType(int paramIndex, Type parameterType, Annotation[] annotationsOnParameter) {
        this.field = null;
        this.fieldFromTestClass = false;
        this.accessModifiers = 0;
        this.mocked = this.getAnnotation(annotationsOnParameter, Mocked.class);
        this.capturing = this.getAnnotation(annotationsOnParameter, Capturing.class);
        this.cascading = this.getAnnotation(annotationsOnParameter, Cascading.class);
        this.nonStrict = this.getAnnotation(annotationsOnParameter, NonStrict.class) != null;
        this.declaredType = parameterType;
        this.mockId = "param" + paramIndex;
        this.registerCascadingIfSpecified();
    }

    private <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> annotation) {
        for (Annotation paramAnnotation : annotations) {
            if (paramAnnotation.annotationType() != annotation) continue;
            return (A)paramAnnotation;
        }
        return null;
    }

    Class<?> getClassType() {
        if (this.declaredType instanceof Class) {
            return (Class)this.declaredType;
        }
        if (this.declaredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.declaredType;
            return (Class)parameterizedType.getRawType();
        }
        return null;
    }

    boolean isMockField() {
        boolean mock = this.mocked != null || this.capturing != null || this.cascading != null || this.nonStrict;
        return (mock || !this.fieldFromTestClass && !Modifier.isPrivate(this.accessModifiers)) && this.isMockableType();
    }

    private boolean isMockableType() {
        if (this.declaredType instanceof Class) {
            Class classType = (Class)this.declaredType;
            return !classType.isPrimitive() && !classType.isArray() && classType != Integer.class;
        }
        return true;
    }

    boolean isMockParameter() {
        return this.isMockableType();
    }

    boolean isFinalFieldOrParameter() {
        return this.field == null || Modifier.isFinal(this.accessModifiers);
    }

    String[] getFilters() {
        if (this.mocked == null) {
            return null;
        }
        String[] filters = this.mocked.methods();
        if (filters.length == 0) {
            filters = this.mocked.value();
        }
        return filters;
    }

    boolean hasInverseFilters() {
        return this.mocked != null && this.mocked.inverse();
    }

    boolean isClassInitializationToBeStubbedOut() {
        if (this.mocked == null || this.mocked.stubOutClassInitialization().length == 0) {
            return STUB_OUT_STATIC_INITIALIZERS;
        }
        return this.mocked.stubOutClassInitialization()[0];
    }

    String getConstructorArgsMethod() {
        return this.mocked == null ? "" : this.mocked.constructorArgsMethod();
    }

    int getMaxInstancesToCapture() {
        if (this.capturing != null) {
            return this.capturing.maxInstances();
        }
        if (this.mocked != null) {
            return this.mocked.capture();
        }
        return 0;
    }

    String getRealClassName() {
        return this.mocked == null ? "" : this.mocked.realClassName();
    }

    public int hashCode() {
        int h;
        int result = this.declaredType.hashCode();
        if (Modifier.isFinal(this.accessModifiers)) {
            result *= 31;
        }
        if (this.mocked != null && (h = this.mocked.hashCode()) != DUMMY_HASHCODE) {
            result = 31 * result + h;
        }
        return result;
    }

    static {
        int h = 0;
        try {
            h = MockedType.class.getDeclaredField("DUMMY").getAnnotation(Mocked.class).hashCode();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        DUMMY_HASHCODE = h;
        STUB_OUT_STATIC_INITIALIZERS = System.getProperty("jmockit-retainStaticInitializers") == null;
    }
}

