/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import sbt_inc.SbtIncrementalCompiler;
import sbt_inc.SbtIncrementalCompilers;
import scala_maven.MavenArtifactResolver;
import scala_maven.ScalaSourceMojoSupport;
import scala_maven_dependency.Context;
import scala_maven_executions.JavaMainCaller;
import util.JavaLocator;
import xsbti.CompileFailed;
import xsbti.compile.CompileOrder;

public abstract class ScalaCompilerSupport
extends ScalaSourceMojoSupport {
    private boolean compileErrors;
    @Parameter(property="recompileMode", defaultValue="incremental")
    RecompileMode recompileMode;
    @Parameter(property="notifyCompilation", defaultValue="true")
    private boolean notifyCompilation;
    @Parameter(property="compileOrder", defaultValue="Mixed")
    private CompileOrder compileOrder;
    @Parameter(property="secondaryCacheDir")
    private File secondaryCacheDir;
    private long _lastCompileAt = -1L;
    private SbtIncrementalCompiler incremental;

    protected abstract File getOutputDir() throws Exception;

    protected abstract Set<File> getClasspathElements() throws Exception;

    protected abstract File getAnalysisCacheFile() throws Exception;

    @Override
    protected void doExecute() throws Exception {
        if (this.getLog().isDebugEnabled()) {
            for (File directory : this.getSourceDirectories()) {
                this.getLog().debug((CharSequence)util.FileUtils.pathOf(directory, this.useCanonicalPath));
            }
        }
        File outputDir = util.FileUtils.fileOf(this.getOutputDir(), this.useCanonicalPath);
        File analysisCacheFile = util.FileUtils.fileOf(this.getAnalysisCacheFile(), this.useCanonicalPath);
        int nbFiles = this.compile(this.getSourceDirectories(), outputDir, analysisCacheFile, this.getClasspathElements(), false);
        if (this.hasCompileErrors()) {
            throw new MojoFailureException("scala compilation failed");
        }
        switch (nbFiles) {
            case -1: {
                this.getLog().info((CharSequence)"No sources to compile");
                break;
            }
            case 0: {
                this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
                break;
            }
        }
    }

    protected JavaMainCaller getScalaCommand() throws Exception {
        Context sc = this.findScalaContext();
        return this.getScalaCommand(this.fork, sc.compilerMainClassName(this.scalaClassName, false));
    }

    protected int compile(List<File> sourceRootDirs, File outputDir, File analysisCacheFile, Set<File> classpathElements, boolean compileInLoop) throws Exception {
        List<File> files;
        if (!compileInLoop && this.recompileMode == RecompileMode.incremental) {
            long n0 = System.nanoTime();
            int res = this.incrementalCompile(classpathElements, sourceRootDirs, outputDir, analysisCacheFile, false);
            this.getLog().info((CharSequence)String.format("compile in %.1f s", (double)(System.nanoTime() - n0) / 1.0E9));
            return res;
        }
        long t0 = System.currentTimeMillis();
        long n0 = System.nanoTime();
        LastCompilationInfo lastCompilationInfo = LastCompilationInfo.find(sourceRootDirs, outputDir);
        if (this._lastCompileAt < 0L) {
            this._lastCompileAt = lastCompilationInfo.getLastSuccessfulTS();
        }
        if ((files = this.getFilesToCompile(sourceRootDirs, this._lastCompileAt)) == null) {
            return -1;
        }
        if (files.size() < 1) {
            return 0;
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        long n1 = System.nanoTime();
        long t1 = t0 + (n1 - n0) / 1000000L;
        if (compileInLoop && this.recompileMode == RecompileMode.incremental) {
            int retCode = this.incrementalCompile(classpathElements, sourceRootDirs, outputDir, analysisCacheFile, true);
            this._lastCompileAt = t1;
            if (retCode == 1) {
                lastCompilationInfo.setLastSuccessfulTS(t1);
            }
            return retCode;
        }
        this.getLog().info((CharSequence)String.format("Compiling %d source files to %s at %d", files.size(), outputDir.getAbsolutePath(), t1));
        JavaMainCaller jcmd = this.getScalaCommand();
        jcmd.redirectToLog();
        if (!classpathElements.isEmpty()) {
            jcmd.addArgs("-classpath", util.FileUtils.toMultiPath(classpathElements));
        }
        jcmd.addArgs("-d", outputDir.getAbsolutePath());
        for (File f : files) {
            jcmd.addArgs(f.getAbsolutePath());
        }
        try {
            if (jcmd.run(this.displayCmd, !compileInLoop)) {
                lastCompilationInfo.setLastSuccessfulTS(t1);
            } else {
                this.compileErrors = true;
            }
        }
        catch (Exception e) {
            this.compileErrors = true;
            this.getLog().error((CharSequence)"exception compilation error occurred!!!", (Throwable)e);
        }
        this.getLog().info((CharSequence)String.format("prepare-compile in %.1f s", (double)(n1 - n0) / 1.0E9));
        this.getLog().info((CharSequence)String.format("compile in %.1f s", (double)(System.nanoTime() - n1) / 1.0E9));
        this._lastCompileAt = t1;
        return files.size();
    }

    boolean hasCompileErrors() {
        return this.compileErrors;
    }

    void clearCompileErrors() {
        this.compileErrors = false;
    }

    private List<File> getFilesToCompile(List<File> sourceRootDirs, long lastSuccessfulCompileTime) throws Exception {
        List<File> sourceFiles = this.findSourceWithFilters(sourceRootDirs);
        if (sourceFiles.size() == 0) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(sourceFiles.size());
        if (this._lastCompileAt > 0L || this.recompileMode != RecompileMode.all && lastSuccessfulCompileTime > 0L) {
            ArrayList<File> modifiedScalaFiles = new ArrayList<File>(sourceFiles.size());
            ArrayList<File> modifiedJavaFiles = new ArrayList<File>(sourceFiles.size());
            for (File f : sourceFiles) {
                if (f.lastModified() < lastSuccessfulCompileTime) continue;
                if (f.getName().endsWith(".java")) {
                    modifiedJavaFiles.add(f);
                    continue;
                }
                modifiedScalaFiles.add(f);
            }
            if (modifiedScalaFiles.size() != 0 || modifiedJavaFiles.size() != 0) {
                files.addAll(sourceFiles);
                this.notifyCompilation(sourceRootDirs);
            }
        } else {
            files.addAll(sourceFiles);
            this.notifyCompilation(sourceRootDirs);
        }
        return files;
    }

    private void notifyCompilation(List<File> files) throws Exception {
        if (this.notifyCompilation) {
            for (File f : files) {
                this.getLog().info((CharSequence)String.format("%s:-1: info: compiling", util.FileUtils.pathOf(f, this.useCanonicalPath)));
            }
        }
    }

    private int incrementalCompile(Set<File> classpathElements, List<File> sourceRootDirs, File outputDir, File cacheFile, boolean compileInLoop) throws Exception {
        List<File> sources = this.findSourceWithFilters(sourceRootDirs);
        if (sources.isEmpty()) {
            return -1;
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (this.incremental == null) {
            Context sc = this.findScalaContext();
            File javaHome = JavaLocator.findHomeFromToolchain(this.getToolchain());
            this.incremental = SbtIncrementalCompilers.make(javaHome, new MavenArtifactResolver(this.factory, this.session), this.secondaryCacheDir, this.getLog(), cacheFile, this.compileOrder, sc.version(), sc.findCompilerAndDependencies().stream().map(Artifact::getFile).collect(Collectors.toList()), sc.findLibraryAndDependencies().stream().map(Artifact::getFile).collect(Collectors.toList()), this.jvmArgs, JavaLocator.findExecutableFromToolchain(this.getToolchain()), this.pluginArtifacts.stream().map(Artifact::getFile).collect(Collectors.toList()));
        }
        try {
            this.incremental.compile(classpathElements, sources, outputDir, this.getScalacOptions(), this.getJavacOptions());
        }
        catch (CompileFailed e) {
            if (compileInLoop) {
                this.compileErrors = true;
            }
            throw e;
        }
        return 1;
    }

    public static enum RecompileMode {
        all,
        incremental;

    }

    private static class LastCompilationInfo {
        private final File _lastCompileAtFile;
        private final File _outputDir;

        static LastCompilationInfo find(List<File> sourceRootDirs, File outputDir) {
            StringBuilder hash = new StringBuilder();
            for (File f : sourceRootDirs) {
                hash.append(f.toString());
            }
            return new LastCompilationInfo(new File(outputDir.getAbsolutePath() + "." + hash.toString().hashCode() + ".timestamp"), outputDir);
        }

        private LastCompilationInfo(File f, File outputDir) {
            this._lastCompileAtFile = f;
            this._outputDir = outputDir;
        }

        long getLastSuccessfulTS() {
            long back = -1L;
            if (this._lastCompileAtFile.exists() && this._outputDir.exists() && this._outputDir.list().length > 0) {
                back = this._lastCompileAtFile.lastModified();
            }
            return back;
        }

        void setLastSuccessfulTS(long v) throws Exception {
            if (!this._lastCompileAtFile.exists()) {
                FileUtils.fileWrite((String)this._lastCompileAtFile.getAbsolutePath(), (String)".");
            }
            this._lastCompileAtFile.setLastModified(v);
        }
    }
}

