/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.client;

import java.util.ArrayList;
import java.util.List;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.client.Client;
import net.greghaines.jesque.json.ObjectMapperFactory;
import net.greghaines.jesque.utils.JedisUtils;
import net.greghaines.jesque.utils.JesqueUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Transaction;

public abstract class AbstractClient
implements Client {
    private final String namespace;

    protected AbstractClient(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.namespace = config.getNamespace();
    }

    protected String getNamespace() {
        return this.namespace;
    }

    protected String key(String ... parts) {
        return JesqueUtils.createKey(this.namespace, parts);
    }

    @Override
    public void enqueue(String queue, Job job) {
        AbstractClient.validateArguments(queue, job);
        try {
            this.doEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void batchEnqueue(String queue, List<Job> jobs) {
        if (jobs == null) {
            throw new IllegalArgumentException("job list must not be null");
        }
        AbstractClient.validateQueue(queue);
        for (Job job : jobs) {
            AbstractClient.validateJob(job);
        }
        ArrayList<String> serializedJobs = new ArrayList<String>(jobs.size());
        try {
            for (Job job : jobs) {
                serializedJobs.add(ObjectMapperFactory.get().writeValueAsString((Object)job));
            }
            this.doBatchEnqueue(queue, serializedJobs);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void priorityEnqueue(String queue, Job job) {
        AbstractClient.validateArguments(queue, job);
        try {
            this.doPriorityEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean acquireLock(String lockName, String lockHolder, int timeout) {
        if (lockName == null || "".equals(lockName)) {
            throw new IllegalArgumentException("lockName must not be null or empty: " + lockName);
        }
        if (lockHolder == null || "".equals(lockHolder)) {
            throw new IllegalArgumentException("lockHolder must not be null or empty: " + lockHolder);
        }
        if (timeout < 1) {
            throw new IllegalArgumentException("timeout must be a positive number");
        }
        try {
            return this.doAcquireLock(lockName, lockHolder, timeout);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void doEnqueue(String var1, String var2) throws Exception;

    protected abstract void doBatchEnqueue(String var1, List<String> var2) throws Exception;

    protected abstract void doPriorityEnqueue(String var1, String var2) throws Exception;

    protected abstract boolean doAcquireLock(String var1, String var2, int var3) throws Exception;

    public static void doEnqueue(Jedis jedis, String namespace, String queue, String jobJson) {
        jedis.sadd(JesqueUtils.createKey(namespace, "queues"), new String[]{queue});
        jedis.rpush(JesqueUtils.createKey(namespace, "queue", queue), new String[]{jobJson});
    }

    public static void doBatchEnqueue(Jedis jedis, String namespace, String queue, List<String> jobJsons) {
        Pipeline pipelined = jedis.pipelined();
        pipelined.sadd(JesqueUtils.createKey(namespace, "queues"), new String[]{queue});
        for (String jobJson : jobJsons) {
            pipelined.rpush(JesqueUtils.createKey(namespace, "queue", queue), new String[]{jobJson});
        }
        pipelined.sync();
    }

    public static void doPriorityEnqueue(Jedis jedis, String namespace, String queue, String jobJson) {
        jedis.sadd(JesqueUtils.createKey(namespace, "queues"), new String[]{queue});
        jedis.lpush(JesqueUtils.createKey(namespace, "queue", queue), new String[]{jobJson});
    }

    public static boolean doAcquireLock(Jedis jedis, String namespace, String lockName, String lockHolder, int timeout) {
        String key = JesqueUtils.createKey(namespace, lockName);
        String existingLockHolder = jedis.get(key);
        if (existingLockHolder != null && existingLockHolder.equals(lockHolder) && jedis.expire(key, timeout) == 1L && (existingLockHolder = jedis.get(key)) != null && existingLockHolder.equals(lockHolder)) {
            return true;
        }
        if (jedis.exists(key).booleanValue() && jedis.ttl(key) < 0L) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (jedis.ttl(key) < 0L) {
                existingLockHolder = jedis.get(key);
                if (existingLockHolder != null && existingLockHolder.equals(lockHolder)) {
                    if (jedis.expire(key, timeout) == 1L && (existingLockHolder = jedis.get(key)) != null && existingLockHolder.equals(lockHolder)) {
                        return true;
                    }
                } else {
                    jedis.del(key);
                }
            } else {
                return false;
            }
        }
        if (jedis.setnx(key, lockHolder) == 1L) {
            if (jedis.expire(key, timeout) == 1L) {
                existingLockHolder = jedis.get(key);
                if (existingLockHolder != null && existingLockHolder.equals(lockHolder)) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public static void doDelayedEnqueue(Jedis jedis, String namespace, String queue, String jobJson, long future) {
        String key = JesqueUtils.createKey(namespace, "queue", queue);
        if (!JedisUtils.canUseAsDelayedQueue(jedis, key)) {
            throw new IllegalArgumentException(queue + " cannot be used as a delayed queue");
        }
        jedis.zadd(key, (double)future, jobJson);
        jedis.sadd(JesqueUtils.createKey(namespace, "queues"), new String[]{queue});
    }

    protected abstract void doDelayedEnqueue(String var1, String var2, long var3) throws Exception;

    @Override
    public void delayedEnqueue(String queue, Job job, long future) {
        AbstractClient.validateArguments(queue, job, future);
        try {
            this.doDelayedEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job), future);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void doRemoveDelayedEnqueue(Jedis jedis, String namespace, String queue, String jobJson) {
        String key = JesqueUtils.createKey(namespace, "queue", queue);
        if (!JedisUtils.canUseAsDelayedQueue(jedis, key)) {
            throw new IllegalArgumentException(queue + " cannot be used as a delayed queue");
        }
        jedis.zrem(key, new String[]{jobJson});
    }

    protected abstract void doRemoveDelayedEnqueue(String var1, String var2) throws Exception;

    @Override
    public void removeDelayedEnqueue(String queue, Job job) {
        AbstractClient.validateArguments(queue, job);
        try {
            this.doRemoveDelayedEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void doRecurringEnqueue(Jedis jedis, String namespace, String queue, String jobJson, long future, long frequency) {
        String hashKey;
        String queueKey = JesqueUtils.createKey(namespace, "queue", queue);
        if (JedisUtils.canUseAsRecurringQueue(jedis, queueKey, hashKey = JesqueUtils.createRecurringHashKey(queueKey))) {
            Transaction transaction = jedis.multi();
            transaction.zadd(queueKey, (double)future, jobJson);
            transaction.hset(hashKey, jobJson, String.valueOf(frequency));
            if (transaction.exec() == null) {
                throw new RuntimeException("cannot add " + jobJson + " to recurring queue " + queue);
            }
        } else {
            throw new IllegalArgumentException(queue + " cannot be used as a recurring queue");
        }
    }

    protected abstract void doRecurringEnqueue(String var1, String var2, long var3, long var5) throws Exception;

    @Override
    public void recurringEnqueue(String queue, Job job, long future, long frequency) {
        AbstractClient.validateArguments(queue, job, future, frequency);
        try {
            this.doRecurringEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job), future, frequency);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void doRemoveRecurringEnqueue(Jedis jedis, String namespace, String queue, String jobJson) {
        String hashKey;
        String queueKey = JesqueUtils.createKey(namespace, "queue", queue);
        if (JedisUtils.canUseAsRecurringQueue(jedis, queueKey, hashKey = JesqueUtils.createRecurringHashKey(queueKey))) {
            Transaction transaction = jedis.multi();
            transaction.hdel(hashKey, new String[]{jobJson});
            transaction.zrem(queueKey, new String[]{jobJson});
            if (transaction.exec() == null) {
                throw new RuntimeException("cannot remove " + jobJson + " from recurring queue " + queue);
            }
        } else {
            throw new IllegalArgumentException(queue + " cannot be used as a recurring queue");
        }
    }

    protected abstract void doRemoveRecurringEnqueue(String var1, String var2) throws Exception;

    @Override
    public void removeRecurringEnqueue(String queue, Job job) {
        AbstractClient.validateArguments(queue, job);
        try {
            this.doRemoveRecurringEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void validateArguments(String queue, Job job) {
        AbstractClient.validateQueue(queue);
        AbstractClient.validateJob(job);
    }

    private static void validateJob(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job must not be null");
        }
        if (!job.isValid()) {
            throw new IllegalStateException("job is not valid: " + job);
        }
    }

    private static void validateQueue(String queue) {
        if (queue == null || "".equals(queue)) {
            throw new IllegalArgumentException("queue must not be null or empty: " + queue);
        }
    }

    private static void validateArguments(String queue, Job job, long future) {
        AbstractClient.validateArguments(queue, job);
        AbstractClient.validateFuture(future);
    }

    private static void validateFuture(long future) {
        if (System.currentTimeMillis() > future) {
            throw new IllegalArgumentException("future must be after current time");
        }
    }

    private static void validateArguments(String queue, Job job, long future, long frequency) {
        AbstractClient.validateArguments(queue, job, future);
        AbstractClient.validateFrequency(frequency);
    }

    private static void validateFrequency(long frequency) {
        if (frequency < 1L) {
            throw new IllegalArgumentException("frequency must be greater than one second");
        }
    }
}

