/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.greghaines.jesque.utils.ConcurrentSet;

public class ConcurrentHashSet<E>
implements ConcurrentSet<E>,
Serializable {
    private static final long serialVersionUID = -7388600825502125963L;
    private final ConcurrentMap<E, Nothing> delegate;

    public ConcurrentHashSet() {
        this.delegate = new ConcurrentHashMap<E, Nothing>();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.delegate = new ConcurrentHashMap<E, Nothing>(initialCapacity);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        this.delegate = new ConcurrentHashMap<E, Nothing>(initialCapacity, loadFactor);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.delegate = new ConcurrentHashMap<E, Nothing>(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentHashSet(Collection<? extends E> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        this.delegate = new ConcurrentHashMap<E, Nothing>(Math.max(16, Math.round((float)collection.size() * 1.5f)));
        for (E elem : collection) {
            this.delegate.put(elem, Nothing.NOTHING);
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.delegate.containsKey(obj);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.delegate.keySet().toArray(array);
    }

    @Override
    public boolean add(E elem) {
        return this.delegate.put(elem, Nothing.NOTHING) == null;
    }

    @Override
    public boolean remove(Object obj) {
        return this.delegate.remove(obj) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.keySet().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E elem : collection) {
            changed |= this.add(elem);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.delegate.keySet().retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate.keySet().removeAll(collection);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    private static enum Nothing {
        NOTHING;

    }
}

