/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public final class ScriptUtils {
    public static String readScript(String resourceName) throws IOException {
        StringBuilder buf = new StringBuilder();
        try (InputStream inputStream = ScriptUtils.class.getResourceAsStream(resourceName);){
            if (inputStream == null) {
                throw new IOException("Could not find script resource: " + resourceName);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                String prefix = "";
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    buf.append(prefix).append(line.trim());
                    prefix = "\n";
                }
            }
        }
        return buf.toString();
    }

    private ScriptUtils() {
    }
}

