/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.worker;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.utils.JesqueUtils;
import net.greghaines.jesque.worker.JobFactory;

public class MapBasedJobFactory
implements JobFactory {
    private final ConcurrentMap<String, Class<?>> jobTypes = new ConcurrentHashMap();

    public MapBasedJobFactory(Map<String, ? extends Class<?>> jobTypes) {
        this.setJobTypes(jobTypes);
    }

    @Override
    public Object materializeJob(Job job) throws Exception {
        return JesqueUtils.materializeJob(job, this.jobTypes);
    }

    public Map<String, Class<?>> getJobTypes() {
        return Collections.unmodifiableMap(this.jobTypes);
    }

    public void addJobType(String jobName, Class<?> jobType) {
        this.checkJobType(jobName, jobType);
        this.jobTypes.put(jobName, jobType);
    }

    public void removeJobType(Class<?> jobType) {
        if (jobType == null) {
            throw new IllegalArgumentException("jobType must not be null");
        }
        this.jobTypes.values().remove(jobType);
    }

    public void removeJobName(String jobName) {
        if (jobName == null) {
            throw new IllegalArgumentException("jobName must not be null");
        }
        this.jobTypes.remove(jobName);
    }

    public void setJobTypes(Map<String, ? extends Class<?>> jobTypes) {
        this.checkJobTypes(jobTypes);
        this.jobTypes.clear();
        this.jobTypes.putAll(jobTypes);
    }

    protected void checkJobTypes(Map<String, ? extends Class<?>> jobTypes) {
        if (jobTypes == null) {
            throw new IllegalArgumentException("jobTypes must not be null");
        }
        for (Map.Entry<String, Class<?>> entry : jobTypes.entrySet()) {
            try {
                this.checkJobType(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("jobTypes contained invalid value", iae);
            }
        }
    }

    protected void checkJobType(String jobName, Class<?> jobType) {
        if (jobName == null) {
            throw new IllegalArgumentException("jobName must not be null");
        }
        if (jobType == null) {
            throw new IllegalArgumentException("jobType must not be null");
        }
        if (!Runnable.class.isAssignableFrom(jobType) && !Callable.class.isAssignableFrom(jobType)) {
            throw new IllegalArgumentException("jobType must implement either Runnable or Callable: " + jobType);
        }
    }
}

