/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.spring.ExtendedLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.KotlinReflectionParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.PrioritizedParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

class SpringLockConfigurationExtractor
implements ExtendedLockConfigurationExtractor {
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext();
    public static final PrioritizedParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new PrioritizedParameterNameDiscoverer();
    private final Duration defaultLockAtMostFor;
    private final Duration defaultLockAtLeastFor;
    private final @Nullable StringValueResolver embeddedValueResolver;
    private final @Nullable BeanFactory beanFactory;
    private final StandardEvaluationContext originalEvaluationContext = new StandardEvaluationContext();
    private final Converter<String, Duration> durationConverter;
    private final Logger logger = LoggerFactory.getLogger(SpringLockConfigurationExtractor.class);

    public SpringLockConfigurationExtractor(Duration defaultLockAtMostFor, Duration defaultLockAtLeastFor, @Nullable StringValueResolver embeddedValueResolver, Converter<String, Duration> durationConverter) {
        this(defaultLockAtMostFor, defaultLockAtLeastFor, embeddedValueResolver, durationConverter, null);
    }

    public SpringLockConfigurationExtractor(Duration defaultLockAtMostFor, Duration defaultLockAtLeastFor, @Nullable StringValueResolver embeddedValueResolver, Converter<String, Duration> durationConverter, @Nullable BeanFactory beanFactory) {
        this.defaultLockAtMostFor = Objects.requireNonNull(defaultLockAtMostFor);
        this.defaultLockAtLeastFor = Objects.requireNonNull(defaultLockAtLeastFor);
        this.durationConverter = Objects.requireNonNull(durationConverter);
        this.embeddedValueResolver = embeddedValueResolver;
        this.beanFactory = beanFactory;
        this.originalEvaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
    }

    public Optional<LockConfiguration> getLockConfiguration(Runnable task) {
        if (task instanceof ScheduledMethodRunnable) {
            ScheduledMethodRunnable scheduledMethodRunnable = (ScheduledMethodRunnable)task;
            return this.getLockConfiguration(scheduledMethodRunnable.getTarget(), scheduledMethodRunnable.getMethod(), new Object[0]);
        }
        this.logger.debug("Unknown task type {}", (Object)task);
        return Optional.empty();
    }

    @Override
    public Optional<LockConfiguration> getLockConfiguration(@Nullable Object target, Method method, @Nullable Object[] parameterValues) {
        AnnotationData annotation = SpringLockConfigurationExtractor.findAnnotation(target, method);
        if (annotation != null) {
            return Optional.of(this.getLockConfiguration(annotation, method, parameterValues));
        }
        return Optional.empty();
    }

    private LockConfiguration getLockConfiguration(AnnotationData annotation, Method method, @Nullable Object[] parameterValues) {
        return new LockConfiguration(ClockProvider.now(), this.getName(annotation, method, parameterValues), this.getLockAtMostFor(annotation), this.getLockAtLeastFor(annotation));
    }

    private String getName(AnnotationData annotation, Method method, @Nullable Object[] parameterValues) {
        String name = this.parseSpEL(annotation.name(), method, parameterValues);
        if (this.embeddedValueResolver != null) {
            String resolved = this.embeddedValueResolver.resolveStringValue(name);
            return resolved != null ? resolved : name;
        }
        return name;
    }

    private String parseSpEL(String name, Method method, @Nullable Object[] parameterValues) {
        return this.getEvaluationContext(method, parameterValues).map(evaluationContext -> (String)EXPRESSION_PARSER.parseExpression(name, PARSER_CONTEXT).getValue(evaluationContext, String.class)).orElse(name);
    }

    private Optional<EvaluationContext> getEvaluationContext(Method method, @Nullable Object[] parameterValues) {
        if (method.getParameters().length > 0 && method.getParameters().length == parameterValues.length) {
            MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)this.beanFactory, method, parameterValues, (ParameterNameDiscoverer)PARAMETER_NAME_DISCOVERER);
            this.originalEvaluationContext.applyDelegatesTo((StandardEvaluationContext)evaluationContext);
            return Optional.of(evaluationContext);
        }
        return Optional.empty();
    }

    Duration getLockAtMostFor(AnnotationData annotation) {
        return this.getValue(annotation.lockAtMostFor(), annotation.lockAtMostForString(), this.defaultLockAtMostFor, "lockAtMostForString");
    }

    Duration getLockAtLeastFor(AnnotationData annotation) {
        return this.getValue(annotation.lockAtLeastFor(), annotation.lockAtLeastForString(), this.defaultLockAtLeastFor, "lockAtLeastForString");
    }

    private Duration getValue(long valueFromAnnotation, String stringValueFromAnnotation, Duration defaultValue, String paramName) {
        if (valueFromAnnotation >= 0L) {
            return Duration.of(valueFromAnnotation, ChronoUnit.MILLIS);
        }
        if (StringUtils.hasText((String)stringValueFromAnnotation)) {
            if (this.embeddedValueResolver != null) {
                stringValueFromAnnotation = this.embeddedValueResolver.resolveStringValue(stringValueFromAnnotation);
            }
            try {
                Objects.requireNonNull(stringValueFromAnnotation, "Invalid " + paramName + " value");
                Duration result = (Duration)this.durationConverter.convert((Object)stringValueFromAnnotation);
                if (result == null || result.isNegative()) {
                    throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot set negative duration");
                }
                return result;
            }
            catch (IllegalStateException nfe) {
                throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot parse into long nor duration");
            }
        }
        return defaultValue;
    }

    static @Nullable AnnotationData findAnnotation(@Nullable Object target, Method method) {
        SchedulerLock annotation = SpringLockConfigurationExtractor.findAnnotation(target, method, SchedulerLock.class);
        if (annotation != null) {
            return new AnnotationData(annotation.name(), -1L, annotation.lockAtMostFor(), -1L, annotation.lockAtLeastFor());
        }
        return null;
    }

    static <A extends Annotation> @Nullable A findAnnotation(@Nullable Object target, Method method, Class<A> annotationType) {
        Annotation annotation = AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, annotationType);
        if (annotation != null) {
            return (A)annotation;
        }
        if (target != null) {
            Class targetClass = AopUtils.getTargetClass((Object)target);
            try {
                Method methodOnTarget = targetClass.getMethod(method.getName(), method.getParameterTypes());
                return (A)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)methodOnTarget, annotationType);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    static {
        if (KotlinDetector.isKotlinReflectPresent()) {
            PARAMETER_NAME_DISCOVERER.addDiscoverer((ParameterNameDiscoverer)new KotlinReflectionParameterNameDiscoverer());
        }
        PARAMETER_NAME_DISCOVERER.addDiscoverer((ParameterNameDiscoverer)new SimpleParameterNameDiscoverer());
    }

    record AnnotationData(String name, long lockAtMostFor, String lockAtMostForString, long lockAtLeastFor, String lockAtLeastForString) {
    }

    private static class SimpleParameterNameDiscoverer
    implements ParameterNameDiscoverer {
        private SimpleParameterNameDiscoverer() {
        }

        public @Nullable String @Nullable [] getParameterNames(Method method) {
            return this.getParameterNames(method.getParameters());
        }

        public @Nullable String @Nullable [] getParameterNames(Constructor<?> ctor) {
            return this.getParameterNames(ctor.getParameters());
        }

        private @Nullable String @Nullable [] getParameterNames(Parameter[] parameters) {
            String[] parameterNames = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter param = parameters[i];
                if (param.getName() == null) {
                    return null;
                }
                parameterNames[i] = param.getName();
            }
            return parameterNames;
        }
    }
}

