/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.sql;

import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlStatementsSource;

class MsSqlServerTimeStatementsSource
extends SqlStatementsSource {
    private static final String now = "SYSUTCDATETIME()";
    private static final String lockAtMostFor = "DATEADD(millisecond, :lockAtMostForMillis, SYSUTCDATETIME())";

    MsSqlServerTimeStatementsSource(SqlConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, DATEADD(millisecond, :lockAtMostForMillis, SYSUTCDATETIME()), SYSUTCDATETIME(), :lockedBy)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = DATEADD(millisecond, :lockAtMostForMillis, SYSUTCDATETIME()), " + this.lockedAt() + " = SYSUTCDATETIME(), " + this.lockedBy() + " = :lockedBy WHERE " + this.name() + " = :name AND " + this.lockUntil() + " <= SYSUTCDATETIME()";
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = "DATEADD(millisecond, :lockAtLeastForMillis, " + this.lockedAt() + ")";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > SYSUTCDATETIME() THEN " + lockAtLeastFor + " ELSE SYSUTCDATETIME() END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = DATEADD(millisecond, :lockAtMostForMillis, SYSUTCDATETIME()) WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > SYSUTCDATETIME()";
    }

    @Override
    public Map<String, Object> params(LockConfiguration lockConfiguration) {
        return Map.of("name", lockConfiguration.getName(), "lockedBy", this.configuration.getLockedByValue(), "lockAtMostForMillis", lockConfiguration.getLockAtMostFor().toMillis(), "lockAtLeastForMillis", lockConfiguration.getLockAtLeastFor().toMillis());
    }
}

