/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.util.Objects;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.composite.ObjectMapperAware;
import net.logstash.logback.pattern.AbstractJsonPatternParser;
import net.logstash.logback.pattern.NodeWriter;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.ObjectMapper;

public abstract class AbstractPatternJsonProvider<Event extends DeferredProcessingAware>
extends AbstractJsonProvider<Event>
implements ObjectMapperAware {
    private NodeWriter<Event> nodeWriter;
    private String pattern;
    protected ObjectMapper objectMapper;
    private boolean omitEmptyFields;

    @Override
    public void writeTo(JsonGenerator generator, Event event) {
        if (this.nodeWriter != null) {
            this.nodeWriter.write(generator, event);
        }
    }

    protected abstract AbstractJsonPatternParser<Event> createParser();

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @Override
    public void start() {
        if (this.objectMapper == null) {
            throw new IllegalStateException("objectMapper has not been set");
        }
        try {
            this.nodeWriter = this.initializeNodeWriter();
        }
        catch (AbstractJsonPatternParser.JsonPatternException e) {
            this.nodeWriter = null;
            this.addError("Invalid [pattern]: " + e.getMessage(), e);
        }
        super.start();
    }

    private NodeWriter<Event> initializeNodeWriter() throws AbstractJsonPatternParser.JsonPatternException {
        AbstractJsonPatternParser<Event> parser = this.createParser();
        parser.setOmitEmptyFields(this.omitEmptyFields);
        return parser.parse(this.pattern);
    }

    public boolean isOmitEmptyFields() {
        return this.omitEmptyFields;
    }

    public void setOmitEmptyFields(boolean omitEmptyFields) {
        this.omitEmptyFields = omitEmptyFields;
    }
}

