/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.incap.processor;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

public class IncrementalAnnotationProcessorProcessor
extends AbstractProcessor {
    private static final String ANNOTATION_NAME = IncrementalAnnotationProcessor.class.getCanonicalName();
    private static final String ANNOTATION_SIMPLE_NAME = IncrementalAnnotationProcessor.class.getSimpleName();
    static final String RESOURCE_FILE = "META-INF/gradle/incremental.annotation.processors";
    private final SortedMap<String, IncrementalAnnotationProcessorType> processors = new TreeMap<String, IncrementalAnnotationProcessorType>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(ANNOTATION_NAME);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(roundEnv);
        }
        return true;
    }

    private void processAnnotations(RoundEnvironment roundEnv) {
        TypeElement processor = this.processingEnv.getElementUtils().getTypeElement(Processor.class.getCanonicalName());
        for (Element element : roundEnv.getElementsAnnotatedWith(IncrementalAnnotationProcessor.class)) {
            if (!this.checkAnnotatedElement(element, processor)) continue;
            IncrementalAnnotationProcessorType processorType = element.getAnnotation(IncrementalAnnotationProcessor.class).value();
            this.processors.put(this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString(), processorType);
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        try {
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", RESOURCE_FILE, new Element[0]);
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(fileObject.openOutputStream(), StandardCharsets.UTF_8));){
                this.processors.forEach((processor, type) -> out.println(processor + "," + type.name()));
                if (out.checkError()) {
                    throw new IOException("Error writing to the file");
                }
            }
        }
        catch (IOException e) {
            this.fatalError("Unable to create META-INF/gradle/incremental.annotation.processors, " + e);
        }
    }

    private boolean checkAnnotatedElement(Element e, TypeElement processor) {
        switch (e.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                this.error("@" + ANNOTATION_SIMPLE_NAME + " cannot be applied to an " + (Object)((Object)e.getKind()), e);
                return false;
            }
            default: {
                return false;
            }
        }
        if (!this.processingEnv.getTypeUtils().isSubtype(e.asType(), processor.asType())) {
            this.error("@" + ANNOTATION_SIMPLE_NAME + " annotated class must implement " + processor.getQualifiedName(), e);
            return false;
        }
        return true;
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, this.getAnnotationMirror(element));
    }

    private AnnotationMirror getAnnotationMirror(Element element) {
        return element.getAnnotationMirrors().stream().filter(annotationMirror -> ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(ANNOTATION_NAME)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }
}

