/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.fontbox.cmap.CMap;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.GlyphMapReader;
import org.mabb.fontverter.opentype.CmapTable;
import org.mabb.fontverter.opentype.NameTable;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.OpenTypeParser;

public class PsType0ToOpenTypeConverter {
    private OpenTypeFont otfFont;
    private PDType0Font type0Font;

    public FVFont convert(PDType0Font type0Font) throws IOException, IllegalAccessException, InstantiationException {
        this.type0Font = type0Font;
        PDCIDFont descendantFont = type0Font.getDescendantFont();
        this.otfFont = this.getOtfFromDescendantFont(descendantFont);
        this.convertCmap();
        if (this.otfFont.getNameTable() == null || this.isCffDescendant()) {
            this.convertNameRecords();
        }
        this.otfFont.finalizeFont();
        this.otfFont.normalize();
        return this.otfFont;
    }

    private OpenTypeFont getOtfFromDescendantFont(PDCIDFont descendantFont) throws IOException, InstantiationException, IllegalAccessException {
        if (this.isTtfDescendant()) {
            byte[] ttfData = this.type0Font.getFontDescriptor().getFontFile2().toByteArray();
            OpenTypeParser otfParser = new OpenTypeParser();
            return otfParser.parse(ttfData);
        }
        if (this.isCffDescendant()) {
            return this.buildFromCff();
        }
        throw new IOException("Descendant font type not supported: " + descendantFont.getClass().getSimpleName());
    }

    private OpenTypeFont buildFromCff() throws IOException {
        byte[] cffData = this.type0Font.getFontDescriptor().getFontFile3().toByteArray();
        OpenTypeFont otfFont = (OpenTypeFont)FontVerter.convertFont(cffData, FontVerter.FontFormat.OTF);
        return otfFont;
    }

    private void convertCmap() throws IllegalAccessException, IOException {
        ArrayList<GlyphMapReader.GlyphMapping> glyphMappings = new ArrayList<GlyphMapReader.GlyphMapping>();
        Map<Integer, String> charToUnicode = this.getType0CharToUnicode();
        for (Map.Entry<Integer, String> nameSetOn : charToUnicode.entrySet()) {
            String name = nameSetOn.getValue();
            char charCode = name.charAt(0);
            int glyphId = nameSetOn.getKey();
            if (name.length() > 2 || charCode >= '\uffff') {
                throw new IOException("Multi byte glyph name not supported.");
            }
            if (charCode == '\u0000') continue;
            glyphMappings.add(new GlyphMapReader.GlyphMapping(glyphId, Integer.valueOf(charCode), name));
        }
        CmapTable cmapTable = CmapTable.createDefaultTable();
        cmapTable.addGlyphMapping(glyphMappings);
        this.otfFont.setCmap(cmapTable);
    }

    private void convertNameRecords() {
        NameTable names = NameTable.createDefaultTable();
        String fullName = this.type0Font.getName();
        String family = this.type0Font.getName();
        String subFamily = "Normal";
        Matcher matcher = Pattern.compile("([^-^+]*)(\\+|-)([^-]*)-?([^-]*)?").matcher(this.type0Font.getName());
        if (matcher.find()) {
            family = matcher.group(3);
            String subMatch = matcher.group(4);
            if (!StringUtils.isEmpty((CharSequence)subMatch) && !subMatch.equals("Identity")) {
                subFamily = subMatch;
            }
        }
        names.setFontFullName(fullName);
        names.setPostScriptName(family);
        names.setFontFamily(family);
        names.setFontSubFamily(subFamily);
        this.otfFont.setName(names);
    }

    private Map<Integer, String> getType0CharToUnicode() throws IllegalAccessException {
        CMap cmap = (CMap)FontVerterUtils.findPrivateField("toUnicodeCMap", PDFont.class).get(this.type0Font);
        if (cmap == null) {
            return new HashMap<Integer, String>();
        }
        return this.getCmapUnicodeMap(cmap);
    }

    private Map<Integer, String> getCmapUnicodeMap(CMap cmap) throws IllegalAccessException {
        Object mappings = FontVerterUtils.findPrivateField("charToUnicode", cmap.getClass()).get(cmap);
        if (mappings == null) {
            return new HashMap<Integer, String>();
        }
        return (Map)mappings;
    }

    private boolean isTtfDescendant() {
        return this.type0Font.getDescendantFont() instanceof PDCIDFontType2;
    }

    private boolean isCffDescendant() {
        return this.type0Font.getDescendantFont() instanceof PDCIDFontType0;
    }
}

