/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.io;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.List;
import org.mabb.fontverter.io.DataTypeAnnotationReader;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.io.DataTypeSerializerException;
import org.mabb.fontverter.io.FontDataOutputStream;

public class DataTypeBindingSerializer {
    private FontDataOutputStream writer;
    private DataTypeAnnotationReader propReader = new DataTypeAnnotationReader();

    public byte[] serialize(Object object) throws DataTypeSerializerException {
        this.writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        Class<?> type = object.getClass();
        List<AccessibleObject> properties = this.propReader.getProperties(type);
        for (AccessibleObject propertyOn : properties) {
            try {
                this.serializeProperty(object, propertyOn);
            }
            catch (Exception e) {
                throw new DataTypeSerializerException("Error serializing property: " + propertyOn.toString(), e);
            }
        }
        try {
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new DataTypeSerializerException(ex);
        }
        return this.writer.toByteArray();
    }

    private void serializeProperty(Object object, AccessibleObject propertyOn) throws Exception {
        Object propValue;
        if (!propertyOn.isAnnotationPresent(DataTypeProperty.class)) {
            return;
        }
        DataTypeProperty annotation = propertyOn.getAnnotation(DataTypeProperty.class);
        DataTypeProperty property = annotation;
        if (this.propReader.isIgnoreProperty(property, object)) {
            return;
        }
        if (propertyOn instanceof Method) {
            propValue = ((Method)propertyOn).invoke(object, new Object[0]);
        } else if (propertyOn instanceof Field) {
            propValue = ((Field)propertyOn).get(object);
        } else {
            throw new DataTypeSerializerException("Byte property binding on unknown type");
        }
        if (property.isArray()) {
            this.writeArrayValue((Object[])propValue, property, object);
        } else {
            this.writeValue(property, propValue);
        }
    }

    private void writeValue(DataTypeProperty property, Object fieldValue) throws IOException {
        switch (property.dataType()) {
            case SHORT: {
                this.writer.writeShort(((Number)fieldValue).shortValue());
                break;
            }
            case USHORT: {
                this.writer.writeUnsignedShort(((Number)fieldValue).intValue());
                break;
            }
            case LONG: {
                this.writer.writeInt(((Number)fieldValue).intValue());
                break;
            }
            case ULONG: {
                this.writer.writeUnsignedInt((int)((Number)fieldValue).longValue());
                break;
            }
            case FIXED32: {
                this.writer.write32Fixed(((Number)fieldValue).floatValue());
                break;
            }
            case UINT: 
            case INT: {
                this.writer.writeInt(((Number)fieldValue).intValue());
                break;
            }
            case STRING: {
                this.writer.writeString((String)fieldValue);
                break;
            }
            case BYTE_ARRAY: {
                this.writer.write((byte[])fieldValue);
                break;
            }
            case LONG_DATE_TIME: {
                Calendar date = (Calendar)fieldValue;
                this.writer.writeLong(date.getTimeInMillis() / 1000L);
                break;
            }
            case PASCAL_STRING: {
                String value = (String)fieldValue;
                this.writer.writeByte(value.length());
                this.writer.writeString(value);
                break;
            }
            case BYTE: {
                this.writer.writeByte(((Byte)fieldValue).byteValue());
                break;
            }
            case UINT_BASE_128: {
                throw new IOException("Data type annotation serialization is not implemented for type: " + (Object)((Object)property.dataType()));
            }
        }
    }

    private void writeArrayValue(Object[] array, DataTypeProperty binding, Object object) throws NoSuchFieldException, IllegalAccessException, IOException, InvocationTargetException {
        int arrayLength = this.propReader.getPropertyArrayLength(binding, object);
        if (arrayLength < 0) {
            throw new IOException("Array length must be set for array data types.");
        }
        for (int i = 0; i < arrayLength; ++i) {
            this.writeValue(binding, array[i]);
        }
    }
}

