/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mabb.fontverter.GlyphMapReader;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.OtfNameConstants;

abstract class CmapSubTable {
    public static final int CMAP_RECORD_BYTE_SIZE = 8;
    protected int formatNumber;
    protected long languageId = 0L;
    protected byte[] rawReadData;
    private int platformId;
    private int encodingId;
    private long subTableOffset;
    private int[] glyphIdToCharacterCode;
    private Map<Integer, Integer> characterCodeToGlyphId;

    CmapSubTable() {
    }

    public long getSubTableOffset() {
        return this.subTableOffset;
    }

    long getLanguageId() {
        return this.languageId;
    }

    public void setSubTableOffset(long subTableOffset) {
        this.subTableOffset = subTableOffset;
    }

    public byte[] getRecordData() throws IOException {
        FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        writer.writeUnsignedShort(this.platformId);
        writer.writeUnsignedShort(this.encodingId);
        writer.writeUnsignedInt((int)this.subTableOffset);
        return writer.toByteArray();
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int platformId) {
        this.platformId = platformId;
    }

    public OtfNameConstants.OtfEncodingType getEncodingType() {
        return OtfNameConstants.OtfEncodingType.fromInt(this.encodingId);
    }

    public void setEncodingId(int encodingId) {
        this.encodingId = encodingId;
    }

    public abstract byte[] getData() throws IOException;

    public abstract int glyphCount();

    public abstract void readData(FontDataInputStream var1) throws IOException;

    public List<GlyphMapReader.GlyphMapping> getGlyphMappings() {
        return new ArrayList<GlyphMapReader.GlyphMapping>();
    }

    static class Format14SubTable
    extends CmapSubTable {
        public Format14SubTable() {
            this.formatNumber = 14;
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedInt(this.rawReadData.length + 6);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            long length = input.readUnsignedInt();
            this.rawReadData = input.readBytes((int)(length - 6L));
            input = new FontDataInputStream(this.rawReadData);
            this.languageId = input.readUnsignedInt();
        }
    }

    static class Format13SubTable
    extends CmapSubTable {
        public Format13SubTable() {
            this.formatNumber = 13;
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(0);
            writer.writeUnsignedInt(this.rawReadData.length + 8);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            int reserved = input.readUnsignedShort();
            long length = input.readUnsignedInt();
            this.rawReadData = input.readBytes((int)(length - 8L));
            input = new FontDataInputStream(this.rawReadData);
            this.languageId = input.readUnsignedInt();
        }
    }

    static class Format12SubTable
    extends CmapSubTable {
        public Format12SubTable() {
            this.formatNumber = 12;
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(0);
            writer.writeUnsignedInt(this.rawReadData.length + 8);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            int reserved = input.readUnsignedShort();
            long length = input.readUnsignedInt();
            this.rawReadData = input.readBytes((int)(length - 8L));
            input = new FontDataInputStream(this.rawReadData);
            this.languageId = input.readUnsignedInt();
        }
    }

    static class Format10SubTable
    extends CmapSubTable {
        public Format10SubTable() {
            this.formatNumber = 10;
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(0);
            writer.writeUnsignedInt(this.rawReadData.length + 8);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            int reserved = input.readUnsignedShort();
            long length = input.readUnsignedInt();
            this.rawReadData = input.readBytes((int)(length - 8L));
            input = new FontDataInputStream(this.rawReadData);
            this.languageId = input.readUnsignedInt();
        }
    }

    static class Format8SubTable
    extends CmapSubTable {
        public Format8SubTable() {
            this.formatNumber = 8;
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(0);
            writer.writeUnsignedInt(this.rawReadData.length + 8);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            int reserved = input.readUnsignedShort();
            long length = input.readUnsignedInt();
            this.rawReadData = input.readBytes((int)(length - 8L));
            input = new FontDataInputStream(this.rawReadData);
            this.languageId = input.readUnsignedInt();
        }
    }

    static class Format6SubTable
    extends CmapSubTable {
        public Format6SubTable() {
            this.formatNumber = 6;
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(this.rawReadData.length + 4);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            int length = input.readUnsignedShort();
            this.rawReadData = input.readBytes(length - 4);
            input = new FontDataInputStream(this.rawReadData);
        }
    }

    static class Format2SubTable
    extends CmapSubTable {
        public Format2SubTable() {
            this.formatNumber = 2;
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(this.rawReadData.length + 4);
            writer.write(this.rawReadData);
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            int length = input.readUnsignedShort();
            this.rawReadData = input.readBytes(length - 4);
            input = new FontDataInputStream(this.rawReadData);
        }
    }

    protected static class Format0SubTable
    extends CmapSubTable {
        private static final int FORMAT0_HEADER_SIZE = 262;
        private LinkedHashMap<Integer, Integer> charCodeToGlyphId = new LinkedHashMap();

        public Format0SubTable() {
            this.formatNumber = 0;
            for (int i = 0; i < 256; ++i) {
                this.charCodeToGlyphId.put(i, 0);
            }
        }

        @Override
        public byte[] getData() throws IOException {
            FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
            if (this.rawReadData != null) {
                writer.writeUnsignedShort(this.formatNumber);
                writer.writeUnsignedShort(this.rawReadData.length + 4);
                writer.write(this.rawReadData);
                return writer.toByteArray();
            }
            writer.writeUnsignedShort(this.formatNumber);
            writer.writeUnsignedShort(this.getLength());
            writer.writeUnsignedShort((int)this.getLanguageId());
            for (Map.Entry<Integer, Integer> entry : this.charCodeToGlyphId.entrySet()) {
                writer.writeByte(entry.getValue());
            }
            return writer.toByteArray();
        }

        @Override
        public int glyphCount() {
            return 0;
        }

        private int getLength() {
            return 262;
        }

        public void addGlyphMapping(int characterCode, int glyphId) {
            this.charCodeToGlyphId.put(characterCode, glyphId);
        }

        @Override
        public void readData(FontDataInputStream input) throws IOException {
            int length = input.readUnsignedShort();
            this.rawReadData = input.readBytes(length - 4);
            input = new FontDataInputStream(this.rawReadData);
        }
    }
}

