/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.opentype.CodePageRange;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.opentype.OtfNameConstants;

public class OS2WinMetricsTable
extends OpenTypeTable {
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int version;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short averageCharWidth;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int weightClass;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int widthClass;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short fsType;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short subscriptXSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short subscriptYSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short subscriptXOffset;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short subscriptYOffset;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short superscriptXSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short superscriptYSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short superscriptXOffset;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short superscriptYOffset;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short strikeoutSize;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short strikeoutPosition;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int familyClass;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.BYTE_ARRAY, constLength=10)
    private byte[] panose = new byte[10];
    @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT)
    private long unicodeRange1;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT)
    private long unicodeRange2;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT)
    private long unicodeRange3;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT)
    private long unicodeRange4;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.STRING, constLength=4)
    private String achVendId;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int fsSelection;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int firstCharIndex;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int lastCharIndex;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private int typoAscender;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private int typoDescender;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private int typoLineGap;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int winAscent;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int winDescent;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT, ignoreIf="!isVersion1OrHigher")
    private long codePageRange1;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT, ignoreIf="!isVersion1OrHigher")
    private long codePageRange2;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT, ignoreIf="!isVersion2OrHigher")
    private int sxHeight;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT, ignoreIf="!isVersion2OrHigher")
    private int sCapHeight;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, ignoreIf="!isVersion2OrHigher")
    private int usDefaultChar;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, ignoreIf="!isVersion2OrHigher")
    private int usBreakChar;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, ignoreIf="!isVersion2OrHigher")
    private int usMaxContext;
    private UnicodeRanges unicodeRanges = new UnicodeRanges();
    private CodePageRanges codePageRanges = new CodePageRanges();
    private static byte[] latinPanose = new byte[]{2, 0, 6, 3, 0, 0, 0, 0, 0, 0};

    @Override
    public String getTableType() {
        return "OS/2";
    }

    public static OS2WinMetricsTable createDefaultTable() {
        OS2WinMetricsTable table = new OS2WinMetricsTable();
        table.version = 0;
        table.averageCharWidth = (short)700;
        table.weightClass = OtfNameConstants.WeightClass.MEDIUM.getValue();
        table.widthClass = OtfNameConstants.WidthClass.MEDIUM.getValue();
        table.fsType = 0;
        table.subscriptXSize = (short)650;
        table.subscriptYSize = (short)699;
        table.subscriptXOffset = 0;
        table.subscriptYOffset = (short)140;
        table.superscriptXSize = (short)650;
        table.superscriptYSize = (short)699;
        table.superscriptXOffset = 0;
        table.superscriptYOffset = (short)479;
        table.strikeoutSize = (short)49;
        table.strikeoutPosition = (short)258;
        table.familyClass = 0;
        table.panose = (byte[])latinPanose.clone();
        table.unicodeRange1 = 1L;
        table.unicodeRange2 = 0L;
        table.unicodeRange3 = 0L;
        table.unicodeRange4 = 0L;
        table.achVendId = "xxxx";
        table.fsSelection = 0;
        table.firstCharIndex = 0;
        table.lastCharIndex = 123;
        table.typoAscender = 800;
        table.typoDescender = -200;
        table.typoLineGap = 90;
        table.winAscent = 796;
        table.winDescent = 133;
        table.codePageRange1 = 0L;
        table.codePageRange2 = 0L;
        table.sxHeight = 0;
        table.sCapHeight = 769;
        table.usDefaultChar = 32;
        table.usBreakChar = 32;
        table.usMaxContext = 1;
        return table;
    }

    public boolean isVersion1OrHigher() {
        return this.version >= 1;
    }

    public boolean isVersion2OrHigher() {
        return this.version >= 2;
    }

    public short getAverageCharWidth() {
        return this.averageCharWidth;
    }

    @Override
    void normalize() throws IOException {
        super.normalize();
        if (this.panose == null) {
            this.panose = (byte[])latinPanose.clone();
        }
        this.calcPanose();
        this.calcEncodingRanges();
        if (!this.isFromParsedFont) {
            this.winAscent = this.font.getHhea().ascender;
            this.winDescent = Math.abs(this.font.getHhea().descender);
        }
    }

    private void calcPanose() {
        OtfNameConstants.OtfEncodingType encode = this.font.getCmap().getCmapEncodingType();
        if (encode == OtfNameConstants.OtfEncodingType.SYMBOL) {
            this.panose[0] = 5;
            this.panose[2] = 1;
            this.panose[4] = 1;
        } else {
            this.panose[0] = 2;
        }
    }

    private void calcEncodingRanges() {
        if (this.isFromParsedFont) {
            return;
        }
        OtfNameConstants.OtfEncodingType encode = this.font.getCmap().getCmapEncodingType();
        if (encode == OtfNameConstants.OtfEncodingType.SYMBOL) {
            this.codePageRanges.setPageBit(CodePageRange.SYMBOL_CHARACTER_SET, true);
        } else {
            this.unicodeRanges.setPageBit(CodePageRange.OtfUnicodeRange.BASIC_LATIN, true);
        }
        this.unicodeRange1 = this.unicodeRanges.getRanges().get(0);
        this.unicodeRange2 = this.unicodeRanges.getRanges().get(1);
        this.unicodeRange3 = this.unicodeRanges.getRanges().get(2);
        this.unicodeRange4 = this.unicodeRanges.getRanges().get(3);
        this.codePageRange1 = this.codePageRanges.getRanges().get(0);
        this.codePageRange2 = this.codePageRanges.getRanges().get(1);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setAverageCharWidth(short averageCharWidth) {
        this.averageCharWidth = averageCharWidth;
    }

    public int getWeightClass() {
        return this.weightClass;
    }

    public void setWeightClass(int weightClass) {
        this.weightClass = weightClass;
    }

    public int getWidthClass() {
        return this.widthClass;
    }

    public void setWidthClass(int widthClass) {
        this.widthClass = widthClass;
    }

    public short getFsType() {
        return this.fsType;
    }

    public void setFsType(short fsType) {
        this.fsType = fsType;
    }

    public short getSubscriptXSize() {
        return this.subscriptXSize;
    }

    public void setSubscriptXSize(short subscriptXSize) {
        this.subscriptXSize = subscriptXSize;
    }

    public short getSubscriptYSize() {
        return this.subscriptYSize;
    }

    public void setSubscriptYSize(short subscriptYSize) {
        this.subscriptYSize = subscriptYSize;
    }

    public short getSubscriptXOffset() {
        return this.subscriptXOffset;
    }

    public void setSubscriptXOffset(short subscriptXOffset) {
        this.subscriptXOffset = subscriptXOffset;
    }

    public short getSuperscriptYOffset() {
        return this.superscriptYOffset;
    }

    public void setSuperscriptYOffset(short superscriptYOffset) {
        this.superscriptYOffset = superscriptYOffset;
    }

    public short getSubscriptYOffset() {
        return this.subscriptYOffset;
    }

    public void setSubscriptYOffset(short subscriptYOffset) {
        this.subscriptYOffset = subscriptYOffset;
    }

    public short getSuperscriptXSize() {
        return this.superscriptXSize;
    }

    public void setSuperscriptXSize(short superscriptXSize) {
        this.superscriptXSize = superscriptXSize;
    }

    public short getSuperscriptYSize() {
        return this.superscriptYSize;
    }

    public void setSuperscriptYSize(short superscriptYSize) {
        this.superscriptYSize = superscriptYSize;
    }

    public short getSuperscriptXOffset() {
        return this.superscriptXOffset;
    }

    public void setSuperscriptXOffset(short superscriptXOffset) {
        this.superscriptXOffset = superscriptXOffset;
    }

    public short getStrikeoutSize() {
        return this.strikeoutSize;
    }

    public void setStrikeoutSize(short strikeoutSize) {
        this.strikeoutSize = strikeoutSize;
    }

    public short getStrikeoutPosition() {
        return this.strikeoutPosition;
    }

    public void setStrikeoutPosition(short strikeoutPosition) {
        this.strikeoutPosition = strikeoutPosition;
    }

    public int getFamilyClass() {
        return this.familyClass;
    }

    public void setFamilyClass(int familyClass) {
        this.familyClass = familyClass;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public void setPanose(byte[] panose) {
        this.panose = panose;
    }

    public String getAchVendId() {
        return this.achVendId;
    }

    public void setAchVendId(String achVendId) {
        this.achVendId = achVendId;
    }

    public int getFsSelection() {
        return this.fsSelection;
    }

    public void setFsSelection(int fsSelection) {
        this.fsSelection = fsSelection;
    }

    public int getTypoAscender() {
        return this.typoAscender;
    }

    public void setTypoAscender(int typoAscender) {
        this.typoAscender = typoAscender;
    }

    public int getTypoLineGap() {
        return this.typoLineGap;
    }

    public void setTypoLineGap(int typoLineGap) {
        this.typoLineGap = typoLineGap;
    }

    public int getTypoDescender() {
        return this.typoDescender;
    }

    public void setTypoDescender(int typoDescender) {
        this.typoDescender = typoDescender;
    }

    public int getWinAscent() {
        return this.winAscent;
    }

    public void setWinAscent(int winAscent) {
        this.winAscent = winAscent;
    }

    public int getWinDescent() {
        return this.winDescent;
    }

    public void setWinDescent(int winDescent) {
        this.winDescent = winDescent;
    }

    public int getSxHeight() {
        return this.sxHeight;
    }

    public void setSxHeight(int sxHeight) {
        this.sxHeight = sxHeight;
    }

    public int getsCapHeight() {
        return this.sCapHeight;
    }

    public void setsCapHeight(int sCapHeight) {
        this.sCapHeight = sCapHeight;
    }

    private static class CodePageRanges
    extends BinaryBlock {
        CodePageRanges() {
            super(64);
        }

        public void setPageBit(CodePageRange range, boolean enable) {
            this.binary[range.bit] = enable;
        }

        public void setPageBit(CodePageRange range) {
            this.binary[range.bit] = true;
        }
    }

    private static class UnicodeRanges
    extends BinaryBlock {
        UnicodeRanges() {
            super(128);
        }

        public void setPageBit(CodePageRange.OtfUnicodeRange range, boolean enable) {
            this.binary[range.bit] = enable;
        }

        public void setPageBit(CodePageRange.OtfUnicodeRange range) {
            this.binary[range.bit] = true;
        }
    }

    static class BinaryBlock {
        protected boolean[] binary;

        BinaryBlock(int size) {
            this.binary = new boolean[size];
            for (int i = 0; i < this.binary.length; ++i) {
                this.binary[i] = false;
            }
        }

        ArrayList<Long> getRanges() {
            ArrayList<Long> ranges = new ArrayList<Long>();
            boolean[] reversedBinary = (boolean[])this.binary.clone();
            ArrayUtils.reverse((boolean[])reversedBinary);
            long n = 0L;
            for (int i = 0; i < reversedBinary.length; ++i) {
                boolean isLastBit;
                boolean b = reversedBinary[i];
                n = n << 1 | (long)(b ? 1 : 0);
                boolean bl = isLastBit = (i + 1) % 32 == 0;
                if (!isLastBit) continue;
                ranges.add(n);
                n = 0L;
            }
            Collections.reverse(ranges);
            return ranges;
        }
    }
}

