/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk8;

import java.time.LocalDate;
import net.objectlab.kit.datecalc.common.BaseCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.NonWorkingDayChecker;

public class LocalDateForwardUnlessNegativeHandler
implements HolidayHandler<LocalDate> {
    @Override
    public LocalDate moveCurrentDate(BaseCalculator<LocalDate> calculator) {
        return this.adjustDate(calculator.getCurrentBusinessDate(), calculator.getCurrentIncrement(), (NonWorkingDayChecker<LocalDate>)calculator);
    }

    @Override
    public LocalDate adjustDate(LocalDate startDate, int increment, NonWorkingDayChecker<LocalDate> checker) {
        LocalDate date = startDate;
        while (checker.isNonWorkingDay(date)) {
            if (increment < 0) {
                date = date.minusDays(1L);
                continue;
            }
            date = date.plusDays(1L);
        }
        return date;
    }

    @Override
    public String getType() {
        return "forwardUnlessMovingBack";
    }
}

