/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.openhft.chronicle.core.util.ReadResolvable;

public enum ObjectUtils {


    public static <E> E convertTo(Class<E> eClass, Object o) throws ClassCastException {
        if (eClass.isInstance(o) || o == null) {
            return (E)o;
        }
        if (Enum.class.isAssignableFrom(eClass)) {
            return Enum.valueOf(eClass, o.toString());
        }
        if (o instanceof String) {
            try {
                Method valueOf = eClass.getDeclaredMethod("valueOf", String.class);
                valueOf.setAccessible(true);
                return (E)valueOf.invoke(null, o);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                ClassCastException cce = new ClassCastException();
                cce.initCause(e);
                throw cce;
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<E> constructor = eClass.getDeclaredConstructor(String.class);
                    constructor.setAccessible(true);
                    return constructor.newInstance(o);
                }
                catch (Exception e2) {
                    ClassCastException cce = new ClassCastException();
                    cce.initCause(e2);
                    throw cce;
                }
            }
        }
        if (ReadResolvable.class.isAssignableFrom(eClass)) {
            return (E)o;
        }
        throw new ClassCastException("Unable to convert " + o.getClass() + " " + o + " to " + eClass);
    }
}

