/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom.resource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.fit.pdfdom.resource.HtmlResource;

public class ImageResource
extends HtmlResource {
    private final BufferedImage image;
    private double x = 0.0;
    private double y = 0.0;

    public ImageResource(String name, BufferedImage image) {
        super(name);
        this.image = image;
    }

    @Override
    public byte[] getData() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.image, "PNG", buffer);
        return buffer.toByteArray();
    }

    @Override
    public String getFileEnding() {
        return "png";
    }

    @Override
    public String getMimeType() {
        return "image/png";
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public float getHeight() {
        return this.image.getHeight();
    }

    public float getWidth() {
        return this.image.getWidth();
    }
}

