/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartPlot;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseMeterPlot
extends JRBaseChartPlot
implements JRMeterPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange;
    protected JRValueDisplay valueDisplay;
    protected MeterShapeEnum shape;
    protected List<JRMeterInterval> intervals = new ArrayList<JRMeterInterval>();
    protected Integer meterAngle;
    protected String units;
    protected Double tickInterval;
    protected Color meterBackgroundColor;
    protected Color needleColor;
    protected Color tickColor;
    protected Integer tickCount;
    protected JRFont tickLabelFont;

    public JRBaseMeterPlot(JRChartPlot plot, JRChart chart) {
        super(plot, chart);
        JRMeterPlot meterPlot;
        JRMeterPlot jRMeterPlot = meterPlot = plot instanceof JRMeterPlot ? (JRMeterPlot)plot : null;
        if (meterPlot == null) {
            this.valueDisplay = new JRBaseValueDisplay(null, chart);
        } else {
            this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), chart);
            this.tickLabelFont = meterPlot.getTickLabelFont();
        }
    }

    public JRBaseMeterPlot(JRMeterPlot meterPlot, ChartsBaseObjectFactory factory) {
        super((JRChartPlot)meterPlot, factory);
        JRBaseObjectFactory parentFactory = factory.getParent();
        this.dataRange = new JRBaseDataRange(meterPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), factory);
        this.shape = meterPlot.getShape();
        List<JRMeterInterval> origIntervals = meterPlot.getIntervals();
        this.intervals.clear();
        if (origIntervals != null) {
            for (JRMeterInterval interval : origIntervals) {
                this.intervals.add(new JRMeterInterval(interval, factory));
            }
        }
        this.meterAngle = meterPlot.getMeterAngle();
        this.units = meterPlot.getUnits();
        this.tickInterval = meterPlot.getTickInterval();
        this.tickCount = meterPlot.getTickCount();
        this.meterBackgroundColor = meterPlot.getMeterBackgroundColor();
        this.needleColor = meterPlot.getNeedleColor();
        this.tickColor = meterPlot.getTickColor();
        this.tickLabelFont = parentFactory.getFont((JRStyleContainer)this.getChart(), meterPlot.getTickLabelFont());
    }

    @Override
    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    @Override
    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    @Override
    public MeterShapeEnum getShape() {
        return this.shape;
    }

    @Override
    public List<JRMeterInterval> getIntervals() {
        return this.intervals;
    }

    @Override
    public Integer getMeterAngle() {
        return this.meterAngle;
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public Double getTickInterval() {
        return this.tickInterval;
    }

    @Override
    public Color getMeterBackgroundColor() {
        return this.meterBackgroundColor;
    }

    @Override
    public Color getNeedleColor() {
        return this.needleColor;
    }

    @Override
    public Color getTickColor() {
        return this.tickColor;
    }

    @Override
    public Integer getTickCount() {
        return this.tickCount;
    }

    @Override
    public JRFont getTickLabelFont() {
        return this.tickLabelFont;
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public Object clone(JRChart parentChart) {
        JRBaseMeterPlot clone = (JRBaseMeterPlot)super.clone(parentChart);
        clone.dataRange = (JRDataRange)JRCloneUtils.nullSafeClone((JRCloneable)this.dataRange);
        clone.valueDisplay = this.valueDisplay == null ? null : this.valueDisplay.clone(parentChart);
        clone.intervals = JRCloneUtils.cloneList(this.intervals);
        return clone;
    }
}

