/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.text;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import net.sf.retrotranslator.runtime.impl.Advanced;
import net.sf.retrotranslator.runtime.impl.WeakIdentityTable;

public class _DecimalFormat {
    private static final WeakIdentityTable formats = new WeakIdentityTable(){

        protected _DecimalFormat initialValue() {
            return new _DecimalFormat();
        }

        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };
    private boolean parseBigDecimal;

    protected _DecimalFormat() {
    }

    @Advanced
    public static boolean isParseBigDecimal(DecimalFormat format) {
        _DecimalFormat value = (_DecimalFormat)formats.lookup(format);
        return value != null && value.parseBigDecimal;
    }

    @Advanced
    public static void setParseBigDecimal(DecimalFormat format, boolean newValue) {
        ((_DecimalFormat)_DecimalFormat.formats.obtain((Object)format)).parseBigDecimal = newValue;
    }

    @Advanced
    public static Number parse(DecimalFormat format, String source) throws ParseException {
        return _DecimalFormat.correctNumber(format, format.parse(source));
    }

    @Advanced
    public static Number parse(DecimalFormat format, String source, ParsePosition parsePosition) {
        return _DecimalFormat.correctNumber(format, format.parse(source, parsePosition));
    }

    @Advanced
    public static Object parseObject(DecimalFormat format, String source) throws ParseException {
        return _DecimalFormat.correctObject(format, format.parseObject(source));
    }

    @Advanced
    public static Object parseObject(DecimalFormat format, String source, ParsePosition pos) {
        return _DecimalFormat.correctObject(format, format.parseObject(source, pos));
    }

    private static Number correctNumber(DecimalFormat format, Number number) {
        Double result;
        if (number == null || !_DecimalFormat.isParseBigDecimal(format)) {
            return number;
        }
        if (number instanceof Double && ((result = (Double)number).isInfinite() || result.isNaN())) {
            return result;
        }
        return new BigDecimal(number.toString());
    }

    private static Object correctObject(DecimalFormat format, Object object) {
        return object instanceof Number ? _DecimalFormat.correctNumber(format, (Number)object) : object;
    }

    protected static Number fixNumber(Format format, Number number) {
        return format instanceof DecimalFormat ? (Number)_DecimalFormat.correctNumber((DecimalFormat)format, number) : (Number)number;
    }

    protected static Object fixObject(Format format, Object object) {
        return object instanceof Number ? _DecimalFormat.fixNumber(format, (Number)object) : object;
    }
}

