/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.jbehave.ThucydidesStepInitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThucydidesStepContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThucydidesStepContext.class);
    private Map<Class<?>, Object> stepInstances = Maps.newHashMap();

    public Object newInstanceOf(Class<?> type) {
        if (this.stepInstances.containsKey(type)) {
            return this.stepInstances.get(type);
        }
        Object newInstance = null;
        try {
            ThucydidesWebDriverSupport.getPages();
            newInstance = this.hasConstructorWithPagesParameter(type) ? (Object)this.createNewPageEnabledStepCandidate(type) : (Object)type.newInstance();
        }
        catch (Exception e) {
            throw new ThucydidesStepInitializationError(e);
        }
        this.stepInstances.put(type, newInstance);
        return newInstance;
    }

    private boolean hasConstructorWithPagesParameter(Class<?> type) {
        Class[] constructorArgs = new Class[]{Pages.class};
        try {
            type.getConstructor(constructorArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    private <T> T createNewPageEnabledStepCandidate(Class<T> type) {
        T newInstance = null;
        try {
            Pages pageFactory = ThucydidesWebDriverSupport.getPages();
            Class[] constructorArgs = new Class[]{Pages.class};
            Constructor<T> constructor = type.getConstructor(constructorArgs);
            newInstance = constructor.newInstance(pageFactory);
        }
        catch (Exception e) {
            LOGGER.info("Failed to instantiate page of type {} ({})", type, (Object)e.getMessage());
        }
        return newInstance;
    }

    public void reset() {
        this.stepInstances.clear();
    }
}

