/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir;

import java.nio.charset.Charset;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class CSVDirConfiguration
extends AbstractConfiguration {
    private String keyseparator = ",";
    private String multivalueSeparator;
    private String fileMask;
    private String sourcePath;
    private String deleteColumnName;
    private String encoding = Charset.defaultCharset().name();
    private char textQualifier = (char)34;
    private char fieldDelimiter = (char)44;
    private String[] keyColumnNames;
    private String passwordColumnName;
    private Boolean quotationRequired = Boolean.TRUE;
    private String[] fields;
    private Boolean ignoreHeader = Boolean.TRUE;
    private String statusColumn;
    private String enabledStatusValue = "true";
    private String disabledStatusValue = "false";
    private String defaultStatusValue = "true";

    @ConfigurationProperty(displayMessageKey="sourcePath.display", helpMessageKey="sourcePath.help", required=true, order=1)
    public String getSourcePath() {
        return this.sourcePath;
    }

    @ConfigurationProperty(displayMessageKey="fileMask.display", helpMessageKey="fileMask.help", required=true, order=2)
    public final String getFileMask() {
        return this.fileMask;
    }

    @ConfigurationProperty(displayMessageKey="encoding.display", helpMessageKey="encoding.help", order=3)
    public final String getEncoding() {
        return this.encoding;
    }

    @ConfigurationProperty(displayMessageKey="fieldDelimiter.display", helpMessageKey="fieldDelimiter.help", order=4)
    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getEscapedFieldDelimiter() {
        String escaped;
        switch (this.fieldDelimiter) {
            case ';': {
                escaped = "\\semi";
                break;
            }
            case '\'': {
                escaped = "\\quote";
                break;
            }
            case ' ': {
                escaped = "\\space";
                break;
            }
            case '`': {
                escaped = "\\apos";
                break;
            }
            default: {
                escaped = String.valueOf(this.fieldDelimiter);
            }
        }
        return escaped;
    }

    @ConfigurationProperty(displayMessageKey="textQualifier.display", helpMessageKey="textQualifier.help", order=5)
    public char getTextQualifier() {
        return this.textQualifier;
    }

    @ConfigurationProperty(displayMessageKey="keyColumnName.display", helpMessageKey="keyColumnName.help", required=true, order=6)
    public String[] getKeyColumnNames() {
        return this.keyColumnNames == null ? null : (String[])this.keyColumnNames.clone();
    }

    @ConfigurationProperty(displayMessageKey="passwordColumnName.display", helpMessageKey="passwordColumnName.help", order=7)
    public String getPasswordColumnName() {
        return this.passwordColumnName;
    }

    @ConfigurationProperty(displayMessageKey="deleteColumnName.display", helpMessageKey="deleteColumnName.help", order=8)
    public String getDeleteColumnName() {
        return this.deleteColumnName;
    }

    @ConfigurationProperty(displayMessageKey="quotationRequired.display", helpMessageKey="quotationRequired.help", order=9)
    public Boolean getQuotationRequired() {
        return this.quotationRequired;
    }

    @ConfigurationProperty(displayMessageKey="fields.display", helpMessageKey="fields.help", required=true, order=10)
    public String[] getFields() {
        return this.fields == null ? null : (String[])this.fields.clone();
    }

    @ConfigurationProperty(displayMessageKey="ignoreHeader.display", helpMessageKey="ignoreHeader.help", order=11)
    public Boolean getIgnoreHeader() {
        return this.ignoreHeader;
    }

    @ConfigurationProperty(displayMessageKey="keyseparator.display", helpMessageKey="keyseparator.help", order=12)
    public String getKeyseparator() {
        return this.keyseparator;
    }

    @ConfigurationProperty(displayMessageKey="multivalueSeparator.display", helpMessageKey="multivalueSeparator.help", order=13)
    public String getMultivalueSeparator() {
        return this.multivalueSeparator;
    }

    @ConfigurationProperty(displayMessageKey="defaultStatusValue.display", helpMessageKey="defaultStatusValue.help", required=false, order=14)
    public String getDefaultStatusValue() {
        return this.defaultStatusValue;
    }

    @ConfigurationProperty(displayMessageKey="disabledStatusValue.display", helpMessageKey="disabledStatusValue.help", required=false, order=15)
    public String getDisabledStatusValue() {
        return this.disabledStatusValue;
    }

    @ConfigurationProperty(displayMessageKey="enabledStatusValue.display", helpMessageKey="enabledStatusValue.help", required=false, order=16)
    public String getEnabledStatusValue() {
        return this.enabledStatusValue;
    }

    @ConfigurationProperty(displayMessageKey="statusColumn.display", helpMessageKey="statusColumn.help", required=false, order=17)
    public String getStatusColumn() {
        return this.statusColumn;
    }

    public void setKeyseparator(String keyseparator) {
        this.keyseparator = keyseparator;
    }

    public void setMultivalueSeparator(String multivalueSeparator) {
        this.multivalueSeparator = multivalueSeparator;
    }

    public void setIgnoreHeader(Boolean ignoreHeader) {
        if (ignoreHeader != null) {
            this.ignoreHeader = ignoreHeader;
        }
    }

    public void setDeleteColumnName(String deleteColumnName) {
        this.deleteColumnName = deleteColumnName;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding == null ? Charset.defaultCharset().name() : encoding;
    }

    public void setFieldDelimiter(char fieldDelimeter) {
        this.fieldDelimiter = fieldDelimeter;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public void setKeyColumnNames(String[] keyColumnNames) {
        this.keyColumnNames = keyColumnNames == null ? null : (String[])keyColumnNames.clone();
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }

    public void setPasswordColumnName(String passwordColumnName) {
        this.passwordColumnName = passwordColumnName;
    }

    public void setFields(String[] fields) {
        this.fields = fields == null ? null : (String[])fields.clone();
    }

    public void setQuotationRequired(Boolean quotationRequired) {
        if (quotationRequired != null) {
            this.quotationRequired = quotationRequired;
        }
    }

    public void setDefaultStatusValue(String defaultStatusValue) {
        this.defaultStatusValue = defaultStatusValue;
    }

    public void setDisabledStatusValue(String disabledStatusValue) {
        this.disabledStatusValue = disabledStatusValue;
    }

    public void setEnabledStatusValue(String enabledStatusValue) {
        this.enabledStatusValue = enabledStatusValue;
    }

    public void setStatusColumn(String statusColumn) {
        this.statusColumn = statusColumn;
    }

    public void validate() {
        if (this.encoding == null) {
            throw new IllegalArgumentException("File encoding must not be null!");
        }
        Charset.forName(this.encoding);
        if (this.textQualifier == this.fieldDelimiter) {
            throw new IllegalStateException("Field delimiter and text qualifier can not be equal!");
        }
        if (StringUtil.isBlank((String)this.fileMask)) {
            throw new IllegalArgumentException("File mask must not be blank!");
        }
        if (StringUtil.isBlank((String)this.sourcePath)) {
            throw new IllegalArgumentException("Source path must not be blank!");
        }
        if (this.keyColumnNames == null || this.keyColumnNames.length == 0) {
            throw new IllegalArgumentException("key column name must not be blank!");
        }
        if (this.fields == null || this.fields.length == 0) {
            throw new IllegalArgumentException("Column names must not be blank!");
        }
        if (StringUtil.isBlank((String)this.keyseparator)) {
            throw new IllegalArgumentException("File mask must not be blank!");
        }
    }
}

