/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import net.tirasa.connid.bundles.csvdir.CSVDirConnector;
import net.tirasa.connid.commons.db.FilterWhereBuilder;
import net.tirasa.connid.commons.db.SQLParam;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class CSVDirFilterTranslator
extends AbstractFilterTranslator<FilterWhereBuilder> {
    private final CSVDirConnector connector;
    private final ObjectClass oclass;
    private final OperationOptions options;

    public CSVDirFilterTranslator(CSVDirConnector connector, ObjectClass oclass, OperationOptions options) {
        this.connector = connector;
        this.oclass = oclass;
        this.options = options;
    }

    protected FilterWhereBuilder createBuilder() {
        return new FilterWhereBuilder();
    }

    protected FilterWhereBuilder createAndExpression(FilterWhereBuilder leftExpression, FilterWhereBuilder rightExpression) {
        FilterWhereBuilder build = this.createBuilder();
        build.join("AND", leftExpression, rightExpression);
        return build;
    }

    protected FilterWhereBuilder createOrExpression(FilterWhereBuilder leftExpression, FilterWhereBuilder rightExpression) {
        FilterWhereBuilder build = this.createBuilder();
        build.join("OR", leftExpression, rightExpression);
        return build;
    }

    protected FilterWhereBuilder createEqualsExpression(EqualsFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        if (not) {
            ret.getWhere().append("NOT ");
        }
        for (int i = 0; i < params.length; ++i) {
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if (param.getValue() == null) {
                ret.addNull(param.getName());
                continue;
            }
            ret.addBind(param, "=");
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected FilterWhereBuilder createContainsExpression(ContainsFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        if (not) {
            ret.getWhere().append("NOT ");
        }
        for (int i = 0; i < params.length; ++i) {
            String value;
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if ((value = (String)param.getValue()) == null || !(value instanceof String)) continue;
            if (!value.startsWith("%")) {
                value = "%" + value;
            }
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            ret.addBind(new SQLParam(param.getName(), (Object)value, param.getSqlType()), "LIKE");
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected FilterWhereBuilder createEndsWithExpression(EndsWithFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        if (not) {
            ret.getWhere().append("NOT ");
        }
        for (int i = 0; i < params.length; ++i) {
            String value;
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if ((value = (String)param.getValue()) == null) continue;
            if (!value.startsWith("%")) {
                value = "%" + value;
            }
            ret.addBind(new SQLParam(param.getName(), (Object)value, param.getSqlType()), "LIKE");
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected FilterWhereBuilder createStartsWithExpression(StartsWithFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        if (not) {
            ret.getWhere().append("NOT ");
        }
        for (int i = 0; i < params.length; ++i) {
            String value;
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if ((value = (String)param.getValue()) == null) continue;
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            ret.addBind(new SQLParam(param.getName(), (Object)value, param.getSqlType()), "LIKE");
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected FilterWhereBuilder createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        for (int i = 0; i < params.length; ++i) {
            String value;
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if ((value = (String)param.getValue()) == null) continue;
            String op = not ? "<=" : ">";
            ret.addBind(param, op);
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected FilterWhereBuilder createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        for (int i = 0; i < params.length; ++i) {
            String value;
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if ((value = (String)param.getValue()) == null) continue;
            String op = not ? "<" : ">=";
            ret.addBind(param, op);
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected FilterWhereBuilder createLessThanExpression(LessThanFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        for (int i = 0; i < params.length; ++i) {
            String value;
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if ((value = (String)param.getValue()) == null) continue;
            String op = not ? ">=" : "<";
            ret.addBind(param, op);
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected FilterWhereBuilder createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        Attribute attribute = filter.getAttribute();
        if (!this.validateSearchAttribute(attribute)) {
            return null;
        }
        SQLParam[] params = this.getSQLParam(attribute, this.oclass, this.options);
        if (params == null) {
            return null;
        }
        FilterWhereBuilder ret = this.createBuilder();
        ret.getWhere().append("(");
        for (int i = 0; i < params.length; ++i) {
            String value;
            SQLParam param = params[i];
            if (i > 0) {
                ret.getWhere().append(" AND ");
            }
            if ((value = (String)param.getValue()) == null) continue;
            String op = not ? ">" : "<=";
            ret.addBind(param, op);
        }
        ret.getWhere().append(")");
        return ret;
    }

    protected boolean validateSearchAttribute(Attribute attribute) {
        return !byte[].class.equals(AttributeUtil.getSingleValue((Attribute)attribute).getClass());
    }

    protected SQLParam[] getSQLParam(Attribute attribute, ObjectClass oclass, OperationOptions options) {
        SQLParam[] params;
        String[] values;
        Integer columnType = 12;
        String[] columnNames = this.getColumnName(attribute.getName());
        String[] stringArray = values = AttributeUtil.getSingleValue((Attribute)attribute) != null ? AttributeUtil.getSingleValue((Attribute)attribute).toString().split(((CSVDirConfiguration)this.connector.getConfiguration()).getKeyseparator()) : null;
        if (columnNames.length > 1) {
            params = new SQLParam[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                params[i] = new SQLParam(columnNames[i], values != null && values.length == columnNames.length ? values[i] : null, columnType.intValue());
            }
        } else {
            params = new SQLParam[]{new SQLParam(columnNames[0], values != null && values.length == columnNames.length ? values[0] : null, columnType.intValue())};
        }
        return params;
    }

    protected String[] getColumnName(String attributeName) {
        if (Name.NAME.equalsIgnoreCase(attributeName)) {
            return ((CSVDirConfiguration)this.connector.getConfiguration()).getKeyColumnNames();
        }
        if (Uid.NAME.equalsIgnoreCase(attributeName)) {
            return ((CSVDirConfiguration)this.connector.getConfiguration()).getKeyColumnNames();
        }
        if (!StringUtil.isBlank((String)((CSVDirConfiguration)this.connector.getConfiguration()).getPasswordColumnName()) && OperationalAttributes.PASSWORD_NAME.equalsIgnoreCase(attributeName)) {
            return new String[]{((CSVDirConfiguration)this.connector.getConfiguration()).getPasswordColumnName()};
        }
        return new String[]{attributeName};
    }
}

