/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.methods;

import java.util.HashSet;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.spi.Connector;

public class CSVDirSchema {
    private static final Log LOG = Log.getLog(CSVDirSchema.class);
    private final CSVDirConfiguration conf;
    private final Class<? extends Connector> connectorClass;

    public CSVDirSchema(Class<? extends Connector> connectorClass, CSVDirConfiguration conf) {
        this.connectorClass = connectorClass;
        this.conf = conf;
    }

    public Schema execute() {
        try {
            return this.executeImpl();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "error during updating", new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
    }

    private Schema executeImpl() {
        SchemaBuilder bld = new SchemaBuilder(this.connectorClass);
        String[] keyColumns = this.conf.getKeyColumnNames();
        HashSet<AttributeInfo> attrInfos = new HashSet<AttributeInfo>();
        for (String fieldName : this.conf.getFields()) {
            if (fieldName.equals(this.conf.getDeleteColumnName())) continue;
            AttributeInfoBuilder abld = new AttributeInfoBuilder();
            if (fieldName.equalsIgnoreCase(this.conf.getPasswordColumnName())) {
                abld.setName(OperationalAttributes.PASSWORD_NAME);
            }
            if (fieldName.equalsIgnoreCase(this.conf.getStatusColumn())) {
                abld.setName(OperationalAttributes.ENABLE_NAME);
            } else if (keyColumns != null && keyColumns.length == 1 && fieldName.equalsIgnoreCase(keyColumns[0])) {
                abld.setName(Name.NAME);
            } else {
                abld.setName(fieldName.trim());
            }
            abld.setCreateable(true);
            abld.setUpdateable(true);
            attrInfos.add(abld.build());
        }
        if (keyColumns == null || keyColumns.length > 1) {
            AttributeInfoBuilder abld = new AttributeInfoBuilder();
            abld.setName(Name.NAME);
            abld.setCreateable(true);
            abld.setUpdateable(true);
            attrInfos.add(abld.build());
        }
        bld.defineObjectClass(ObjectClass.ACCOUNT_NAME, attrInfos);
        return bld.build();
    }
}

