/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.javadoc.doclet.Doclet;
import net.sourceforge.plantuml.OptionFlags;
import nl.talsmasoftware.umldoclet.UMLDoclet;
import nl.talsmasoftware.umldoclet.javadoc.DocletConfig;
import nl.talsmasoftware.umldoclet.javadoc.ExternalLink;

final class UMLOptions {
    private final DocletConfig config;
    private final Set<Doclet.Option> standardOptions;
    private final Set<Doclet.Option> options;

    UMLOptions(DocletConfig config) {
        this(config, null);
    }

    private UMLOptions(DocletConfig config, Set<? extends Doclet.Option> standardOptions) {
        this.config = Objects.requireNonNull(config, "Configuration is <null>.");
        this.standardOptions = standardOptions == null ? null : new LinkedHashSet<Doclet.Option>(standardOptions);
        this.options = new TreeSet<Doclet.Option>(Comparator.comparing(o -> o.getNames().get(0), String::compareTo));
        this.options.add(new Option("-quiet", 0, Doclet.Option.Kind.OTHER, args -> {
            config.quiet = true;
        }));
        this.options.add(new Option("-verbose", 0, Doclet.Option.Kind.OTHER, args -> {
            config.verbose = true;
        }));
        this.options.add(new Option("-docencoding", 1, Doclet.Option.Kind.OTHER, args -> {
            config.docencoding = (String)args.get(0);
        }));
        this.options.add(new Option("-encoding", 1, Doclet.Option.Kind.OTHER, args -> {
            config.encoding = (String)args.get(0);
        }));
        this.options.add(new Option("-link", 1, Doclet.Option.Kind.OTHER, args -> config.externalLinks.add(new ExternalLink(config, (String)args.get(0), (String)args.get(0)))));
        this.options.add(new Option("-linkoffline", 2, Doclet.Option.Kind.OTHER, args -> config.externalLinks.add(new ExternalLink(config, (String)args.get(0), (String)args.get(1)))));
        this.options.add(new Option("-private", 0, Doclet.Option.Kind.OTHER, args -> config.showMembers("private")));
        this.options.add(new Option("-package", 0, Doclet.Option.Kind.OTHER, args -> config.showMembers("package")));
        this.options.add(new Option("-protected", 0, Doclet.Option.Kind.OTHER, args -> config.showMembers("protected")));
        this.options.add(new Option("-public", 0, Doclet.Option.Kind.OTHER, args -> config.showMembers("public")));
        this.options.add(new Option("--show-members", 1, Doclet.Option.Kind.OTHER, args -> config.showMembers((String)args.get(0))));
        this.options.add(new Option("-d", 1, Doclet.Option.Kind.OTHER, args -> {
            config.destDirName = (String)args.get(0);
        }));
        this.options.add(new Option("--plantuml-server-url -plantumlServerUrl", 1, Doclet.Option.Kind.STANDARD, args -> {
            config.plantumlServerUrl = (String)args.get(0);
        }));
        this.options.add(new Option("--delegate-doclet -delegateDoclet", 1, Doclet.Option.Kind.STANDARD, args -> {
            config.delegateDoclet = (String)args.get(0);
        }));
        this.options.add(new Option("--create-puml-files -createPumlFiles", 0, Doclet.Option.Kind.STANDARD, args -> {
            config.renderPumlFile = true;
        }));
        this.options.add(new Option("--uml-image-directory -umlImageDirectory", 1, Doclet.Option.Kind.STANDARD, args -> {
            config.images.directory = (String)args.get(0);
        }));
        this.options.add(new Option("--uml-image-format -umlImageFormat", 1, Doclet.Option.Kind.STANDARD, args -> config.images.addImageFormat((String)args.get(0))));
        this.options.add(new Option("--uml-encoding -umlEncoding", 1, Doclet.Option.Kind.STANDARD, args -> {
            config.umlencoding = (String)args.get(0);
        }));
        this.options.add(new Option("--uml-excluded-type-references -umlExcludedTypeReferences", 1, Doclet.Option.Kind.STANDARD, args -> {
            config.excludedReferences = UMLOptions.splitToList((String)args.get(0));
        }));
        this.options.add(new Option("--uml-excluded-package-dependencies -umlExcludedPackageDependencies", 1, Doclet.Option.Kind.STANDARD, args -> {
            config.excludedPackageDependencies = UMLOptions.splitToList((String)args.get(0));
        }));
        this.options.add(new Option("--uml-custom-directive -umlCustomDirective", 1, Doclet.Option.Kind.STANDARD, args -> config.customPlantumlDirectives.add((String)args.get(0))));
        this.options.add(new Option("--fail-on-cyclic-package-dependencies -failOnCyclicPackageDependencies", 1, Doclet.Option.Kind.STANDARD, args -> {
            config.failOnCyclicPackageDependencies = UMLOptions.asBoolean((String)args.get(0));
        }));
        this.options.add(new Option("--uml-java-bean-properties-as-fields -umlJavaBeanPropertiesAsFields", 0, Doclet.Option.Kind.STANDARD, args -> {
            config.methodConfig.javaBeanPropertiesAsFields = true;
        }));
        this.options.add(new Option("--uml-timeout -umlTimeout", 1, Doclet.Option.Kind.STANDARD, this::setTimeout));
    }

    Set<Doclet.Option> mergeWith(Set<? extends Doclet.Option> standardOptions) {
        if (standardOptions == null || standardOptions.isEmpty()) {
            return this.options;
        }
        Set<Doclet.Option> copy = new UMLOptions((DocletConfig)this.config, standardOptions).options;
        copy.addAll(standardOptions);
        return copy;
    }

    private static List<String> splitToList(String value) {
        return value == null || value.isEmpty() ? Collections.emptyList() : Stream.of(value.split("[,;]")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static boolean asBoolean(String value) {
        return "true".equalsIgnoreCase(value);
    }

    private void setTimeout(List<String> timeout) {
        try {
            int timeoutSeconds = Integer.parseInt(timeout.get(0));
            OptionFlags.getInstance().setTimeoutMs(1000L * (long)timeoutSeconds);
        }
        catch (RuntimeException rte) {
            throw new IllegalArgumentException("Unrecognized timeout value: seconds expected, received: " + String.valueOf(timeout), rte);
        }
    }

    private class Option
    implements Doclet.Option {
        private static final String MISSING_KEY = "<MISSING KEY>";
        private final Consumer<List<String>> processor;
        private final String[] names;
        private final String parameters;
        private final String description;
        private final int argCount;
        private final Doclet.Option.Kind kind;

        protected Option(String name, int argCount, Doclet.Option.Kind kind, Consumer<List<String>> processor) {
            this.processor = processor;
            this.names = name.trim().split("\\s+");
            this.description = this.resourceMsg(this.names[0] + ".description");
            this.parameters = this.resourceMsg(this.names[0] + ".parameters");
            this.argCount = argCount;
            this.kind = kind;
        }

        private String resourceMsg(String key) {
            try {
                String resourceKey = "doclet.usage." + key.toLowerCase(Locale.ENGLISH).replaceFirst("^-+", "");
                return ResourceBundle.getBundle(UMLDoclet.class.getName()).getString(resourceKey);
            }
            catch (MissingResourceException mre) {
                return MISSING_KEY;
            }
        }

        @Override
        public String getDescription() {
            return this.findDelegate().map(Doclet.Option::getDescription).filter(s -> !s.isEmpty() && !MISSING_KEY.equals(s)).orElse(this.description);
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return this.kind;
        }

        @Override
        public List<String> getNames() {
            return Arrays.asList(this.names);
        }

        @Override
        public String getParameters() {
            return this.parameters;
        }

        @Override
        public int getArgumentCount() {
            return this.argCount;
        }

        private boolean matches(Doclet.Option other) {
            List otherNames = Optional.ofNullable(other).map(Doclet.Option::getNames).orElse(Collections.emptyList());
            return !otherNames.isEmpty() && this.names[0].equalsIgnoreCase((String)otherNames.get(0));
        }

        private Optional<Doclet.Option> findDelegate() {
            return Optional.ofNullable(UMLOptions.this.standardOptions).flatMap(set -> set.stream().filter(this::matches).findFirst());
        }

        @Override
        public boolean process(String option, List<String> arguments) {
            this.processor.accept(arguments);
            return this.findDelegate().map(delegate -> delegate.process(option, arguments)).orElse(true);
        }

        public String toString() {
            return Arrays.toString(this.names);
        }
    }
}

