/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Diagram;

public class PackageDiagram
extends Diagram {
    private static final String SEPARATOR_DIRECTIVE = "set separator ";
    public static final String SEPARATOR = "::";
    final String moduleName;
    final String packageName;
    private File pumlFile = null;

    public PackageDiagram(Configuration config, String packageName, String moduleName) {
        super(config);
        this.packageName = Objects.requireNonNull(packageName, "Package name is <null>.");
        this.moduleName = moduleName;
    }

    @Override
    protected <IPW extends IndentingPrintWriter> IPW writeCustomDirectives(List<String> customDirectives, IPW output) {
        ArrayList<String> directives = new ArrayList<String>(customDirectives == null ? Collections.emptyList() : customDirectives);
        directives.removeIf(directive -> directive.startsWith(SEPARATOR_DIRECTIVE));
        directives.add("set separator ::");
        return super.writeCustomDirectives(directives, output);
    }

    @Override
    protected File getPlantUmlFile() {
        if (this.pumlFile == null) {
            StringBuilder result = new StringBuilder(this.getConfiguration().destinationDirectory());
            if (result.length() > 0 && result.charAt(result.length() - 1) != '/') {
                result.append('/');
            }
            if (this.moduleName != null) {
                result.append(this.moduleName).append('/');
            }
            result.append(this.packageName.replace('.', '/'));
            result.append("/package.puml");
            this.pumlFile = new File(result.toString());
        }
        return this.pumlFile;
    }
}

