/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;

public class BoundaryCancelEventActivityBehavior
extends BoundaryEventActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        DelegateExecution subProcessExecution = null;
        List<ExecutionEntity> processInstanceExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        for (ExecutionEntity childExecution : processInstanceExecutions) {
            if (childExecution.getCurrentFlowElement() == null || !childExecution.getCurrentFlowElement().getId().equals(boundaryEvent.getAttachedToRefId())) continue;
            subProcessExecution = childExecution;
            break;
        }
        if (subProcessExecution == null) {
            throw new ActivitiException("No execution found for sub process of boundary cancel event " + boundaryEvent.getId());
        }
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        List<CompensateEventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findCompensateEventSubscriptionsByExecutionId(subProcessExecution.getParentId());
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            Activity activity;
            String deleteReason = "boundary event(" + boundaryEvent.getId() + ")";
            ScopeUtil.throwCompensationEvent(eventSubscriptions, execution, false);
            executionEntityManager.deleteExecutionAndRelatedData((ExecutionEntity)subProcessExecution, deleteReason, false);
            if (subProcessExecution.getCurrentFlowElement() instanceof Activity && (activity = (Activity)subProcessExecution.getCurrentFlowElement()).getLoopCharacteristics() != null) {
                ExecutionEntity miExecution = subProcessExecution.getParent();
                List<ExecutionEntity> miChildExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(miExecution.getId());
                for (ExecutionEntity miChildExecution : miChildExecutions) {
                    if (subProcessExecution.getId().equals(miChildExecution.getId()) || !activity.getId().equals(miChildExecution.getCurrentActivityId())) continue;
                    executionEntityManager.deleteExecutionAndRelatedData(miChildExecution, deleteReason, false);
                }
            }
            this.leave(execution);
        }
    }
}

