/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskActivityBehavior.class);
    protected UserTask userTask;

    public UserTaskActivityBehavior(UserTask userTask) {
        this.userTask = userTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        Object formKey;
        Object category;
        Object priority;
        Object dueDate;
        CommandContext commandContext = Context.getCommandContext();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        TaskEntity task = (TaskEntity)taskEntityManager.create();
        task.setExecution((ExecutionEntity)execution);
        task.setTaskDefinitionKey(this.userTask.getId());
        String activeTaskName = null;
        String activeTaskDescription = null;
        String activeTaskDueDate = null;
        String activeTaskPriority = null;
        String activeTaskCategory = null;
        String activeTaskFormKey = null;
        String activeTaskSkipExpression = null;
        String activeTaskAssignee = null;
        String activeTaskOwner = null;
        List<String> activeTaskCandidateUsers = null;
        List<String> activeTaskCandidateGroups = null;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties(this.userTask.getId(), execution.getProcessDefinitionId());
            activeTaskName = this.getActiveValue(this.userTask.getName(), "userTaskName", taskElementProperties);
            activeTaskDescription = this.getActiveValue(this.userTask.getDocumentation(), "userTaskDescription", taskElementProperties);
            activeTaskDueDate = this.getActiveValue(this.userTask.getDueDate(), "userTaskDueDate", taskElementProperties);
            activeTaskPriority = this.getActiveValue(this.userTask.getPriority(), "userTaskPriority", taskElementProperties);
            activeTaskCategory = this.getActiveValue(this.userTask.getCategory(), "userTaskCategory", taskElementProperties);
            activeTaskFormKey = this.getActiveValue(this.userTask.getFormKey(), "userTaskFormKey", taskElementProperties);
            activeTaskSkipExpression = this.getActiveValue(this.userTask.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            activeTaskAssignee = this.getActiveValue(this.userTask.getAssignee(), "userTaskAssignee", taskElementProperties);
            activeTaskOwner = this.getActiveValue(this.userTask.getOwner(), "userTaskOwner", taskElementProperties);
            activeTaskCandidateUsers = this.getActiveValueList(this.userTask.getCandidateUsers(), "userTaskCandidateUsers", taskElementProperties);
            activeTaskCandidateGroups = this.getActiveValueList(this.userTask.getCandidateGroups(), "userTaskCandidateGroups", taskElementProperties);
        } else {
            activeTaskName = this.userTask.getName();
            activeTaskDescription = this.userTask.getDocumentation();
            activeTaskDueDate = this.userTask.getDueDate();
            activeTaskPriority = this.userTask.getPriority();
            activeTaskCategory = this.userTask.getCategory();
            activeTaskFormKey = this.userTask.getFormKey();
            activeTaskSkipExpression = this.userTask.getSkipExpression();
            activeTaskAssignee = this.userTask.getAssignee();
            activeTaskOwner = this.userTask.getOwner();
            activeTaskCandidateUsers = this.userTask.getCandidateUsers();
            activeTaskCandidateGroups = this.userTask.getCandidateGroups();
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskName)) {
            String name = null;
            try {
                name = (String)expressionManager.createExpression(activeTaskName).getValue(execution);
            }
            catch (ActivitiException e) {
                name = activeTaskName;
                LOGGER.warn("property not found in task name expression " + e.getMessage());
            }
            task.setName(name);
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskDescription)) {
            String description = null;
            try {
                description = (String)expressionManager.createExpression(activeTaskDescription).getValue(execution);
            }
            catch (ActivitiException e) {
                description = activeTaskDescription;
                LOGGER.warn("property not found in task description expression " + e.getMessage());
            }
            task.setDescription(description);
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskDueDate) && (dueDate = expressionManager.createExpression(activeTaskDueDate).getValue(execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                String businessCalendarName = null;
                businessCalendarName = StringUtils.isNotEmpty((CharSequence)this.userTask.getBusinessCalendarName()) ? expressionManager.createExpression(this.userTask.getBusinessCalendarName()).getValue(execution).toString() : "dueDate";
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(businessCalendarName);
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeTaskDueDate);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskPriority) && (priority = expressionManager.createExpression(activeTaskPriority).getValue(execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activeTaskPriority);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskCategory) && (category = expressionManager.createExpression(activeTaskCategory).getValue(execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeTaskCategory);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskFormKey) && (formKey = expressionManager.createExpression(activeTaskFormKey).getValue(execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeTaskFormKey);
            }
        }
        taskEntityManager.insert(task, (ExecutionEntity)execution);
        boolean skipUserTask = false;
        if (StringUtils.isNotEmpty((CharSequence)activeTaskSkipExpression)) {
            Expression skipExpression = expressionManager.createExpression(activeTaskSkipExpression);
            boolean bl = skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled(execution, skipExpression) && SkipExpressionUtil.shouldSkipFlowElement(execution, skipExpression);
        }
        if (!skipUserTask) {
            this.handleAssignments(taskEntityManager, activeTaskAssignee, activeTaskOwner, activeTaskCandidateUsers, activeTaskCandidateGroups, task, expressionManager, execution);
        }
        processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(task, "create");
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, task));
        }
        if (skipUserTask) {
            taskEntityManager.deleteTask(task, null, false, false);
            this.leave(execution);
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        CommandContext commandContext = Context.getCommandContext();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        List<TaskEntity> taskEntities = taskEntityManager.findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            throw new ActivitiException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    protected void handleAssignments(TaskEntityManager taskEntityManager, String assignee, String owner, List<String> candidateUsers, List<String> candidateGroups, TaskEntity task, ExpressionManager expressionManager, DelegateExecution execution) {
        Object value;
        Expression idExpression;
        List<String> candidates;
        Object value2;
        if (StringUtils.isNotEmpty((CharSequence)assignee)) {
            Object assigneeExpressionValue = expressionManager.createExpression(assignee).getValue(execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            taskEntityManager.changeTaskAssignee(task, assigneeValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)owner)) {
            Object ownerExpressionValue = expressionManager.createExpression(owner).getValue(execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            taskEntityManager.changeTaskOwner(task, ownerValue);
        }
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            for (String candidateGroup : candidateGroups) {
                Expression groupIdExpr = expressionManager.createExpression(candidateGroup);
                value2 = groupIdExpr.getValue(execution);
                if (value2 instanceof String) {
                    candidates = this.extractCandidates((String)value2);
                    task.addCandidateGroups(candidates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateGroups((Collection)value2);
                    continue;
                }
                throw new ActivitiIllegalArgumentException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            for (String candidateUser : candidateUsers) {
                Expression userIdExpr = expressionManager.createExpression(candidateUser);
                value2 = userIdExpr.getValue(execution);
                if (value2 instanceof String) {
                    candidates = this.extractCandidates((String)value2);
                    task.addCandidateUsers(candidates);
                    continue;
                }
                if (value2 instanceof Collection) {
                    task.addCandidateUsers((Collection)value2);
                    continue;
                }
                throw new ActivitiException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (this.userTask.getCustomUserIdentityLinks() != null && !this.userTask.getCustomUserIdentityLinks().isEmpty()) {
            for (String customUserIdentityLinkType : this.userTask.getCustomUserIdentityLinks().keySet()) {
                for (String userIdentityLink : (Set)this.userTask.getCustomUserIdentityLinks().get(customUserIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(userIdentityLink);
                    value = idExpression.getValue(execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            task.addUserIdentityLink(userId, customUserIdentityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            task.addUserIdentityLink((String)userIdSet.next(), customUserIdentityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
        if (this.userTask.getCustomGroupIdentityLinks() != null && !this.userTask.getCustomGroupIdentityLinks().isEmpty()) {
            for (String customGroupIdentityLinkType : this.userTask.getCustomGroupIdentityLinks().keySet()) {
                for (String groupIdentityLink : (Set)this.userTask.getCustomGroupIdentityLinks().get(customGroupIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(groupIdentityLink);
                    value = idExpression.getValue(execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            task.addGroupIdentityLink(groupId, customGroupIdentityLinkType);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            task.addGroupIdentityLink((String)groupIdSet.next(), customGroupIdentityLinkType);
                        }
                        continue;
                    }
                    throw new ActivitiException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }
}

