/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.impl.HistoricDetailQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.HistoricDetailDataManager;

public class HistoricDetailEntityManagerImpl
extends AbstractEntityManager<HistoricDetailEntity>
implements HistoricDetailEntityManager {
    protected HistoricDetailDataManager historicDetailDataManager;

    public HistoricDetailEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, HistoricDetailDataManager historicDetailDataManager) {
        super(processEngineConfiguration);
        this.historicDetailDataManager = historicDetailDataManager;
    }

    @Override
    protected DataManager<HistoricDetailEntity> getDataManager() {
        return this.historicDetailDataManager;
    }

    @Override
    public HistoricDetailVariableInstanceUpdateEntity copyAndInsertHistoricDetailVariableInstanceUpdateEntity(VariableInstanceEntity variableInstance) {
        HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = this.historicDetailDataManager.createHistoricDetailVariableInstanceUpdate();
        historicVariableUpdate.setProcessInstanceId(variableInstance.getProcessInstanceId());
        historicVariableUpdate.setExecutionId(variableInstance.getExecutionId());
        historicVariableUpdate.setTaskId(variableInstance.getTaskId());
        historicVariableUpdate.setTime(this.getClock().getCurrentTime());
        historicVariableUpdate.setRevision(variableInstance.getRevision());
        historicVariableUpdate.setName(variableInstance.getName());
        historicVariableUpdate.setVariableType(variableInstance.getType());
        historicVariableUpdate.setTextValue(variableInstance.getTextValue());
        historicVariableUpdate.setTextValue2(variableInstance.getTextValue2());
        historicVariableUpdate.setDoubleValue(variableInstance.getDoubleValue());
        historicVariableUpdate.setLongValue(variableInstance.getLongValue());
        if (variableInstance.getBytes() != null) {
            historicVariableUpdate.setBytes(variableInstance.getBytes());
        }
        this.insert(historicVariableUpdate);
        return historicVariableUpdate;
    }

    @Override
    public void delete(HistoricDetailEntity entity, boolean fireDeleteEvent) {
        HistoricDetailVariableInstanceUpdateEntity historicDetailVariableInstanceUpdateEntity;
        super.delete(entity, fireDeleteEvent);
        if (entity instanceof HistoricDetailVariableInstanceUpdateEntity && (historicDetailVariableInstanceUpdateEntity = (HistoricDetailVariableInstanceUpdateEntity)entity).getByteArrayRef() != null) {
            historicDetailVariableInstanceUpdateEntity.getByteArrayRef().delete();
        }
    }

    @Override
    public void deleteHistoricDetailsByProcessInstanceId(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List<HistoricDetailEntity> historicDetails = this.historicDetailDataManager.findHistoricDetailsByProcessInstanceId(historicProcessInstanceId);
            for (HistoricDetailEntity historicDetail : historicDetails) {
                this.delete(historicDetail);
            }
        }
    }

    @Override
    public long findHistoricDetailCountByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        return this.historicDetailDataManager.findHistoricDetailCountByQueryCriteria(historicVariableUpdateQuery);
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery, Page page) {
        return this.historicDetailDataManager.findHistoricDetailsByQueryCriteria(historicVariableUpdateQuery, page);
    }

    @Override
    public void deleteHistoricDetailsByTaskId(String taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            List<HistoricDetailEntity> details = this.historicDetailDataManager.findHistoricDetailsByTaskId(taskId);
            for (HistoricDetail historicDetail : details) {
                this.delete((HistoricDetailEntity)historicDetail);
            }
        }
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.historicDetailDataManager.findHistoricDetailsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findHistoricDetailCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.historicDetailDataManager.findHistoricDetailCountByNativeQuery(parameterMap);
    }

    public HistoricDetailDataManager getHistoricDetailDataManager() {
        return this.historicDetailDataManager;
    }

    public void setHistoricDetailDataManager(HistoricDetailDataManager historicDetailDataManager) {
        this.historicDetailDataManager = historicDetailDataManager;
    }
}

