/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rad.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.rad.SpringContextHolder;
import org.alfresco.rad.test.Remote;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AlfrescoTestRunner
extends BlockJUnit4ClassRunner {
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";

    public AlfrescoTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static String serializableToString(Serializable serializable) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(serializable);
        oos.close();
        String string = Base64.encodeBase64URLSafeString((byte[])baos.toByteArray());
        return string;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.areWeRunningInAlfresco()) {
            super.runChild(method, notifier);
        } else {
            Description desc = this.describeChild(method);
            if (method.getAnnotation(Ignore.class) != null) {
                notifier.fireTestIgnored(desc);
            } else {
                this.callProxiedChild(method, notifier, desc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callProxiedChild(FrameworkMethod method, RunNotifier notifier, Description desc) {
        block31: {
            notifier.fireTestStarted(desc);
            String className = this.getTestClass().getJavaClass().getCanonicalName();
            String methodName = method.getName();
            if (null != methodName) {
                className = className + "#" + methodName;
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin", "admin");
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
            String testWebScriptUrl = "/service/testing/test.xml?clazz=" + className.replace("#", "%23");
            HttpGet get = new HttpGet(this.getContextRoot(method) + testWebScriptUrl);
            try {
                String line;
                CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)get);
                InputStream is = resp.getEntity().getContent();
                InputStreamReader ir = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(ir);
                String body = "";
                while ((line = br.readLine()) != null) {
                    body = body + line + "\n";
                }
                if (body.length() > 0) {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = null;
                    dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(new InputSource(new StringReader(body)));
                    Element root = doc.getDocumentElement();
                    NodeList results = root.getElementsByTagName("result");
                    if (null != results && results.getLength() > 0) {
                        String result = results.item(0).getFirstChild().getNodeValue();
                        if (SUCCESS.equals(result)) {
                            notifier.fireTestFinished(desc);
                            break block31;
                        }
                        boolean failureFired = false;
                        NodeList throwableNodes = root.getElementsByTagName("throwable");
                        for (int tid = 0; tid < throwableNodes.getLength(); ++tid) {
                            String throwableBody = null;
                            Object object = null;
                            Throwable throwable = null;
                            throwableBody = throwableNodes.item(tid).getFirstChild().getNodeValue();
                            if (null != throwableBody) {
                                try {
                                    object = AlfrescoTestRunner.objectFromString(throwableBody);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                                if (null != object && object instanceof Throwable) {
                                    throwable = (Throwable)object;
                                }
                            }
                            if (null == throwable) {
                                throwable = new Throwable("Unable to process exception body: " + throwableBody);
                            }
                            notifier.fireTestFailure(new Failure(desc, throwable));
                            failureFired = true;
                        }
                        if (!failureFired) {
                            notifier.fireTestFailure(new Failure(desc, new Throwable("There was an error but we can't figure out what it was, sorry!")));
                        }
                        break block31;
                    }
                    notifier.fireTestFailure(new Failure(desc, new Throwable("Unable to process response for proxied test request: " + body)));
                    break block31;
                }
                notifier.fireTestFailure(new Failure(desc, new Throwable("Attempt to proxy test into running Alfresco instance failed, no response received")));
            }
            catch (IOException e) {
                notifier.fireTestFailure(new Failure(desc, (Throwable)e));
            }
            catch (ParserConfigurationException e) {
                notifier.fireTestFailure(new Failure(desc, (Throwable)e));
            }
            catch (SAXException e) {
                notifier.fireTestFailure(new Failure(desc, (Throwable)e));
            }
            finally {
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static Object objectFromString(String string) throws IOException, ClassNotFoundException {
        byte[] buffer = Base64.decodeBase64((String)string);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer));
        Object object = ois.readObject();
        ois.close();
        return object;
    }

    protected boolean areWeRunningInAlfresco() {
        SpringContextHolder contextHolder = SpringContextHolder.Instance();
        return contextHolder != null;
    }

    protected String getContextRoot(FrameworkMethod method) {
        Class<?> declaringClass = method.getMethod().getDeclaringClass();
        boolean annotationPresent = declaringClass.isAnnotationPresent(Remote.class);
        if (annotationPresent) {
            Remote annotation = declaringClass.getAnnotation(Remote.class);
            return annotation.endpoint();
        }
        return "http://localhost:8080/alfresco";
    }
}

