/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.BaseMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.DefaultMessageFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.MessageFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArray;

public class CompositeMessage
extends BaseMessage
implements Iterable<Message> {
    protected Message[] msgs;
    protected int index;
    protected boolean collapse;
    protected static final MessageFactory mf = new DefaultMessageFactory();

    public CompositeMessage() {
    }

    public CompositeMessage(Address dest) {
        super(dest);
    }

    public CompositeMessage(Address dest, Message ... messages) {
        super(dest);
        this.add(messages);
    }

    @Override
    public Supplier<Message> create() {
        return CompositeMessage::new;
    }

    @Override
    public short getType() {
        return this.collapse ? (short)0 : 5;
    }

    @Override
    public boolean hasPayload() {
        return this.msgs != null && this.index > 0;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    public int getNumberOfMessages() {
        return this.index;
    }

    @Override
    public int getOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompositeMessage setArray(byte[] b, int o, int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompositeMessage setArray(ByteArray buf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompositeMessage setObject(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject() {
        throw new UnsupportedOperationException();
    }

    public boolean collapse() {
        return this.collapse;
    }

    public CompositeMessage collapse(boolean b) {
        this.collapse = b;
        return this;
    }

    @Override
    public int getLength() {
        int total = 0;
        for (int i = 0; i < this.index && this.msgs != null; ++i) {
            total += this.msgs[i].getLength();
        }
        return total;
    }

    public CompositeMessage add(Message msg) {
        this.ensureSameDest(msg);
        this.ensureCapacity(this.index);
        this.msgs[this.index++] = Objects.requireNonNull(msg);
        return this;
    }

    public CompositeMessage add(Message ... messages) {
        this.ensureCapacity(this.index + messages.length);
        for (Message msg : messages) {
            this.msgs[this.index++] = Objects.requireNonNull(this.ensureSameDest(msg));
        }
        return this;
    }

    public <T extends Message> T get(int index) {
        return (T)this.msgs[index];
    }

    @Override
    public CompositeMessage copy(boolean copy_payload, boolean copy_headers) {
        CompositeMessage retval = (CompositeMessage)super.copy(copy_payload, copy_headers);
        if (copy_payload && this.msgs != null) {
            Message[] copy = new Message[this.msgs.length];
            for (int i = 0; i < this.msgs.length; ++i) {
                if (this.msgs[i] == null) continue;
                copy[i] = this.msgs[i].copy(copy_payload, copy_headers);
            }
            retval.msgs = copy;
            retval.index = this.index;
        }
        return retval;
    }

    @Override
    public String toString() {
        return String.format("%s, %d message(s)", super.toString(), this.getNumberOfMessages());
    }

    @Override
    public int size() {
        int retval = super.size() + 4;
        if (this.msgs != null) {
            for (int i = 0; i < this.index; ++i) {
                retval += this.msgs[i].size() + 2;
            }
        }
        return retval;
    }

    @Override
    public Iterator<Message> iterator() {
        return new CompositeMessageIterator();
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        if (this.collapse) {
            this.writePayloadAsBytes(out);
            return;
        }
        out.writeInt(this.index);
        if (this.msgs != null) {
            for (int i = 0; i < this.index; ++i) {
                Message msg = this.msgs[i];
                out.writeShort(msg.getType());
                msg.writeTo(out);
            }
        }
    }

    @Override
    public void readPayload(DataInput in) throws IOException, ClassNotFoundException {
        this.index = in.readInt();
        if (this.index > 0) {
            this.msgs = new Message[this.index];
            for (int i = 0; i < this.index; ++i) {
                short type = in.readShort();
                this.msgs[i] = mf.create(type);
                this.msgs[i].readFrom(in);
            }
        }
    }

    protected void writePayloadAsBytes(DataOutput out) throws IOException {
        int len = this.getLength();
        out.writeInt(this.msgs == null ? -1 : len);
        if (this.msgs != null) {
            for (int i = 0; i < this.index; ++i) {
                Message msg = this.msgs[i];
                if (msg.hasArray()) {
                    out.write(msg.getArray(), msg.getOffset(), msg.getLength());
                    continue;
                }
                msg.writePayload(out);
            }
        }
    }

    protected void ensureCapacity(int size) {
        if (this.msgs == null) {
            this.msgs = new Message[size + 1];
        } else if (size >= this.msgs.length) {
            this.msgs = Arrays.copyOf(this.msgs, size + 1);
        }
    }

    protected Message ensureSameDest(Message msg) {
        if (!Objects.equals(this.dest, msg.dest())) {
            throw new IllegalStateException(String.format("message's destination (%s) does not match destination of CompositeMessage (%s)", msg.dest(), this.dest));
        }
        return msg;
    }

    protected class CompositeMessageIterator
    implements Iterator<Message> {
        protected int current_index;

        protected CompositeMessageIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current_index < CompositeMessage.this.index;
        }

        @Override
        public Message next() {
            if (this.current_index >= CompositeMessage.this.msgs.length) {
                throw new NoSuchElementException();
            }
            return CompositeMessage.this.msgs[this.current_index++];
        }
    }
}

