/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;

@Converter
public final class CamelConverter {
    private CamelConverter() {
    }

    @Converter
    public static Processor toProcessor(final Predicate predicate) {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                boolean answer = predicate.matches(exchange);
                Message out = exchange.getOut();
                out.copyFrom(exchange.getIn());
                out.setBody((Object)answer);
            }
        };
    }

    @Converter
    public static Processor toProcessor(final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                Object answer = expression.evaluate(exchange, Object.class);
                Message out = exchange.getOut();
                out.copyFrom(exchange.getIn());
                out.setBody(answer);
            }
        };
    }
}

