/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.runtimecatalog.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.runtimecatalog.impl.AbstractCamelCatalog;
import org.apache.camel.runtimecatalog.impl.CamelContextJSonSchemaResolver;

public class DefaultRuntimeCamelCatalog
extends AbstractCamelCatalog
implements RuntimeCamelCatalog {
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private boolean caching;

    public DefaultRuntimeCamelCatalog(CamelContext camelContext) {
        this(camelContext, false);
    }

    public DefaultRuntimeCamelCatalog(CamelContext camelContext, boolean caching) {
        this.caching = caching;
        this.setJSonSchemaResolver(new CamelContextJSonSchemaResolver(camelContext));
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.cache.clear();
    }

    public String modelJSonSchema(String name) {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("model-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getModelJSonSchema(name);
            if (this.caching) {
                this.cache.put("model-" + name, answer);
            }
        }
        return answer;
    }

    public String componentJSonSchema(String name) {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("component-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getComponentJSonSchema(name);
            if (this.caching) {
                this.cache.put("component-" + name, answer);
            }
        }
        return answer;
    }

    public String dataFormatJSonSchema(String name) {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("dataformat-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getDataFormatJSonSchema(name);
            if (this.caching) {
                this.cache.put("dataformat-" + name, answer);
            }
        }
        return answer;
    }

    public String languageJSonSchema(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("language-" + name);
        }
        if (answer == null) {
            answer = this.getJSonSchemaResolver().getLanguageJSonSchema(name);
            if (this.caching) {
                this.cache.put("language-" + name, answer);
            }
        }
        return answer;
    }
}

