/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.CxfOperationException;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.LRUSoftCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfRsProducer
extends DefaultProducer
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsProducer.class);
    private boolean throwException;
    private ClientFactoryBeanCache clientFactoryBeanCache;

    public CxfRsProducer(CxfRsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.clientFactoryBeanCache = new ClientFactoryBeanCache(endpoint.getMaxClientCacheSize());
    }

    protected void doStart() throws Exception {
        this.clientFactoryBeanCache.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.clientFactoryBeanCache.stop();
    }

    public void process(Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        Boolean httpClientAPI = (Boolean)inMessage.getHeader("CamelCxfRsUsingHttpAPI", Boolean.class);
        if (httpClientAPI == null) {
            httpClientAPI = ((CxfRsEndpoint)this.getEndpoint()).isHttpClientAPI();
        }
        if (httpClientAPI.booleanValue()) {
            this.invokeHttpClient(exchange);
        } else {
            this.invokeProxyClient(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Message inMessage = exchange.getIn();
            Boolean httpClientAPI = (Boolean)inMessage.getHeader("CamelCxfRsUsingHttpAPI", Boolean.class);
            if (httpClientAPI == null) {
                httpClientAPI = ((CxfRsEndpoint)this.getEndpoint()).isHttpClientAPI();
            }
            if (httpClientAPI.booleanValue()) {
                this.invokeAsyncHttpClient(exchange, callback);
            } else {
                this.invokeAsyncProxyClient(exchange, callback);
            }
            return false;
        }
        catch (Exception exception) {
            LOG.error("Error invoking request", (Throwable)exception);
            exchange.setException((Throwable)exception);
            callback.done(true);
            return true;
        }
    }

    protected void invokeAsyncHttpClient(Exchange exchange, AsyncCallback callback) throws Exception {
        Message inMessage = exchange.getIn();
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        Bus bus = ((CxfRsEndpoint)this.getEndpoint()).getBus();
        if (bus != null) {
            cfb.setBus(bus);
        }
        WebClient client = cfb.createWebClient();
        ((CxfRsEndpoint)this.getEndpoint()).getChainedCxfRsEndpointConfigurer().configureClient((Client)client);
        String httpMethod = (String)inMessage.getHeader("CamelHttpMethod", String.class);
        Class responseClass = (Class)inMessage.getHeader("CamelCxfRsResponseClass", Class.class);
        Type genericType = (Type)inMessage.getHeader("CamelCxfRsResponseGenericType", Type.class);
        Object[] pathValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String path = (String)inMessage.getHeader("CamelHttpPath", String.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP method = {}", (Object)httpMethod);
            LOG.trace("path = {}", (Object)path);
            LOG.trace("responseClass = {}", (Object)responseClass);
        }
        if (path != null) {
            if (ObjectHelper.isNotEmpty((Object)pathValues) && pathValues.length > 0) {
                client.path(path, pathValues);
            } else {
                client.path((Object)path);
            }
        }
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        Object body = this.getBody(exchange, inMessage, httpMethod, cxfRsEndpoint, binding);
        this.setupClientMatrix(client, exchange);
        this.setupClientQueryAndHeaders(client, exchange);
        if (ObjectHelper.isEmpty((Object)inMessage.getHeader("Content-Type", String.class)) && ObjectHelper.isNotEmpty((Object)client.getHeaders().get((Object)"Content-Type"))) {
            inMessage.setHeader("Content-Type", ((List)client.getHeaders().get((Object)"Content-Type")).get(0));
        }
        Entity<Object> entity = binding.bindCamelMessageToRequestEntity(body, inMessage, exchange);
        CookieHandler cookieHandler = ((CxfRsEndpoint)this.getEndpoint()).getCookieHandler();
        this.loadCookies(exchange, (Client)client, cookieHandler);
        client.async().method(httpMethod, entity, (InvocationCallback)new CxfInvocationCallback((Client)client, exchange, cxfRsEndpoint, responseClass, callback, genericType));
    }

    protected void invokeAsyncProxyClient(Exchange exchange, AsyncCallback callback) throws Exception {
        Message inMessage = exchange.getIn();
        Object[] varValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String methodName = (String)inMessage.getHeader("operationName", String.class);
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        Bus bus = ((CxfRsEndpoint)this.getEndpoint()).getBus();
        if (bus != null) {
            cfb.setBus(bus);
        }
        Client target = varValues == null ? cfb.create() : cfb.createWithValues(varValues);
        ((CxfRsEndpoint)this.getEndpoint()).getChainedCxfRsEndpointConfigurer().configureClient(target);
        this.setupClientHeaders(target, exchange);
        JAXRSServiceFactoryBean sfb = cfb.getServiceFactory();
        sfb.getResourceClasses();
        Object[] parameters = null;
        if (inMessage.getBody() != null) {
            parameters = (Object[])inMessage.getBody(Object[].class);
        }
        Method method = this.findRightMethod(sfb.getResourceClasses(), methodName, this.getParameterTypes(parameters));
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfProxyInvocationCallback invocationCallback = new CxfProxyInvocationCallback(target, exchange, cxfRsEndpoint, callback);
        WebClient.getConfig((Object)target).getRequestContext().put(InvocationCallback.class.getName(), invocationCallback);
        CookieHandler cookieHandler = ((CxfRsEndpoint)this.getEndpoint()).getCookieHandler();
        this.loadCookies(exchange, target, cookieHandler);
        method.invoke((Object)target, parameters);
    }

    protected void setupClientQueryAndHeaders(WebClient client, Exchange exchange) throws Exception {
        String queryString;
        Message inMessage = exchange.getIn();
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        Map<String, String> maps = (Map<String, String>)inMessage.getHeader("CamelCxfRsQueryMap", Map.class);
        if (maps == null && (queryString = (String)inMessage.getHeader("CamelHttpQuery", String.class)) != null) {
            maps = this.getQueryParametersFromQueryString(queryString, IOHelper.getCharsetName((Exchange)exchange));
        }
        if (maps == null) {
            maps = cxfRsEndpoint.getParameters();
        }
        if (maps != null) {
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                client.query(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        this.setupClientHeaders((Client)client, exchange);
    }

    protected void setupClientMatrix(WebClient client, Exchange exchange) throws Exception {
        org.apache.cxf.message.Message cxfMessage = (org.apache.cxf.message.Message)exchange.getIn().getHeader("CamelCxfMessage");
        if (cxfMessage != null) {
            String requestURL = (String)cxfMessage.get((Object)"org.apache.cxf.request.uri");
            String matrixParam = null;
            int matrixStart = requestURL.indexOf(";");
            int matrixEnd = requestURL.indexOf("?") > -1 ? requestURL.indexOf("?") : requestURL.length();
            Map<String, String> maps = null;
            if (requestURL != null && matrixStart > 0 && (matrixParam = requestURL.substring(matrixStart + 1, matrixEnd)) != null) {
                maps = this.getMatrixParametersFromMatrixString(matrixParam, IOHelper.getCharsetName((Exchange)exchange));
            }
            if (maps != null) {
                for (Map.Entry entry : maps.entrySet()) {
                    client.matrix((String)entry.getKey(), new Object[]{entry.getValue()});
                    LOG.debug("Matrix param " + (String)entry.getKey() + " :: " + (String)entry.getValue());
                }
            }
        }
    }

    protected void setupClientHeaders(Client client, Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        client.headers(binding.bindCamelHeadersToRequestHeaders(inMessage.getHeaders(), exchange));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void invokeHttpClient(Exchange exchange) throws Exception {
        Integer respCode;
        void var15_19;
        Message inMessage = exchange.getIn();
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        Bus bus = ((CxfRsEndpoint)this.getEndpoint()).getBus();
        if (bus != null) {
            cfb.setBus(bus);
        }
        WebClient client = cfb.createWebClient();
        ((CxfRsEndpoint)this.getEndpoint()).getChainedCxfRsEndpointConfigurer().configureClient((Client)client);
        String httpMethod = (String)inMessage.getHeader("CamelHttpMethod", String.class);
        Class responseClass = (Class)inMessage.getHeader("CamelCxfRsResponseClass", Class.class);
        Type genericType = (Type)inMessage.getHeader("CamelCxfRsResponseGenericType", Type.class);
        Object[] pathValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String path = (String)inMessage.getHeader("CamelHttpPath", String.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP method = {}", (Object)httpMethod);
            LOG.trace("path = {}", (Object)path);
            LOG.trace("responseClass = {}", (Object)responseClass);
        }
        if (path != null) {
            if (ObjectHelper.isNotEmpty((Object)pathValues) && pathValues.length > 0) {
                client.path(path, pathValues);
            } else {
                client.path((Object)path);
            }
        }
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        Object body = this.getBody(exchange, inMessage, httpMethod, cxfRsEndpoint, binding);
        this.setupClientMatrix(client, exchange);
        this.setupClientQueryAndHeaders(client, exchange);
        CookieHandler cookieHandler = ((CxfRsEndpoint)this.getEndpoint()).getCookieHandler();
        this.loadCookies(exchange, (Client)client, cookieHandler);
        Object var15_15 = null;
        if (responseClass == null || Response.class.equals((Object)responseClass)) {
            Response response = client.invoke(httpMethod, body);
        } else if (Collection.class.isAssignableFrom(responseClass)) {
            if (!(genericType instanceof ParameterizedType)) throw new CamelExchangeException("Header CamelCxfRsResponseGenericType not found in message", exchange);
            Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
            Collection collection = client.invokeAndGetCollection(httpMethod, body, (Class)actualTypeArguments[0]);
        } else {
            Object object = client.invoke(httpMethod, body, responseClass);
        }
        int statesCode = client.getResponse().getStatus();
        this.saveCookies(exchange, (Client)client, cookieHandler);
        if (this.throwException && var15_19 instanceof Response && (respCode = Integer.valueOf(((Response)var15_19).getStatus())) > 207) {
            throw this.populateCxfRsProducerException(exchange, (Response)var15_19, respCode);
        }
        if (exchange.getPattern().isOutCapable()) {
            LOG.trace("Response body = {}", (Object)var15_19);
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            exchange.getOut().setBody(binding.bindResponseToCamelBody(var15_19, exchange));
            exchange.getOut().getHeaders().putAll(binding.bindResponseHeadersToCamelHeaders(var15_19, exchange));
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)statesCode);
            return;
        } else {
            if (!(var15_19 instanceof Response)) return;
            ((Response)var15_19).close();
        }
    }

    private void saveCookies(Exchange exchange, Client client, CookieHandler cookieHandler) {
        if (cookieHandler != null) {
            CookieStore cookieStore = cookieHandler.getCookieStore(exchange);
            for (NewCookie newCookie : client.getResponse().getCookies().values()) {
                HttpCookie cookie = new HttpCookie(newCookie.getName(), newCookie.getValue());
                cookie.setComment(newCookie.getComment());
                cookie.setDomain(newCookie.getDomain());
                cookie.setHttpOnly(newCookie.isHttpOnly());
                cookie.setMaxAge(newCookie.getMaxAge());
                cookie.setPath(newCookie.getPath());
                cookie.setSecure(newCookie.isSecure());
                cookie.setVersion(newCookie.getVersion());
                cookieStore.add(client.getCurrentURI(), cookie);
            }
        }
    }

    private void loadCookies(Exchange exchange, Client client, CookieHandler cookieHandler) throws IOException {
        if (cookieHandler != null) {
            for (Map.Entry cookie : cookieHandler.loadCookies(exchange, client.getCurrentURI()).entrySet()) {
                if (((List)cookie.getValue()).size() <= 0) continue;
                client.header((String)cookie.getKey(), new Object[]{cookie.getValue()});
            }
        }
    }

    protected void invokeProxyClient(Exchange exchange) throws Exception {
        Integer respCode;
        Message inMessage = exchange.getIn();
        Object[] varValues = (Object[])inMessage.getHeader("CamelCxfRsVarValues", Object[].class);
        String methodName = (String)inMessage.getHeader("operationName", String.class);
        Client target = null;
        JAXRSClientFactoryBean cfb = this.clientFactoryBeanCache.get(CxfEndpointUtils.getEffectiveAddress(exchange, ((CxfRsEndpoint)this.getEndpoint()).getAddress()));
        Bus bus = ((CxfRsEndpoint)this.getEndpoint()).getBus();
        if (bus != null) {
            cfb.setBus(bus);
        }
        target = varValues == null ? cfb.create() : cfb.createWithValues(varValues);
        ((CxfRsEndpoint)this.getEndpoint()).getChainedCxfRsEndpointConfigurer().configureClient(target);
        this.setupClientHeaders(target, exchange);
        JAXRSServiceFactoryBean sfb = cfb.getServiceFactory();
        sfb.getResourceClasses();
        Object[] parameters = null;
        if (inMessage.getBody() != null) {
            parameters = (Object[])inMessage.getBody(Object[].class);
        }
        Method method = this.findRightMethod(sfb.getResourceClasses(), methodName, this.getParameterTypes(parameters));
        CookieHandler cookieHandler = ((CxfRsEndpoint)this.getEndpoint()).getCookieHandler();
        this.loadCookies(exchange, target, cookieHandler);
        Object response = method.invoke((Object)target, parameters);
        int statesCode = target.getResponse().getStatus();
        this.saveCookies(exchange, target, cookieHandler);
        if (this.throwException && response instanceof Response && (respCode = Integer.valueOf(((Response)response).getStatus())) > 207) {
            throw this.populateCxfRsProducerException(exchange, (Response)response, respCode);
        }
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsBinding binding = cxfRsEndpoint.getBinding();
        if (exchange.getPattern().isOutCapable()) {
            LOG.trace("Response body = {}", response);
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            exchange.getOut().setBody(binding.bindResponseToCamelBody(response, exchange));
            exchange.getOut().getHeaders().putAll(binding.bindResponseHeadersToCamelHeaders(response, exchange));
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)statesCode);
        } else if (response instanceof Response) {
            ((Response)response).close();
        }
    }

    protected ClientFactoryBeanCache getClientFactoryBeanCache() {
        return this.clientFactoryBeanCache;
    }

    private Map<String, String> getQueryParametersFromQueryString(String queryString, String charset) throws UnsupportedEncodingException {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (String param : queryString.split("&")) {
            String[] pair = param.split("=", 2);
            if (pair.length != 2) {
                throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
            }
            String name = URLDecoder.decode(pair[0], charset);
            String value = URLDecoder.decode(pair[1], charset);
            answer.put(name, value);
        }
        return answer;
    }

    private Method findRightMethod(List<Class<?>> resourceClasses, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        for (Class<?> clazz : resourceClasses) {
            try {
                Method[] m;
                block3: for (Method method : m = clazz.getMethods()) {
                    Class<?>[] params;
                    if (!method.getName().equals(methodName) || (params = method.getParameterTypes()).length != parameterTypes.length) continue;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (!params[i].isAssignableFrom(parameterTypes[i])) continue block3;
                    }
                    return method;
                }
            }
            catch (SecurityException securityException) {
            }
        }
        throw new NoSuchMethodException("Cannot find method with name: " + methodName + " having parameters assignable from: " + this.arrayToString(parameterTypes));
    }

    private Class<?>[] getParameterTypes(Object[] objects) {
        if (objects == null) {
            return new Class[0];
        }
        Class[] answer = new Class[objects.length];
        int i = 0;
        for (Object obj : objects) {
            answer[i] = obj.getClass();
            ++i;
        }
        return answer;
    }

    private Map<String, String> getMatrixParametersFromMatrixString(String matrixString, String charset) throws UnsupportedEncodingException {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (String param : matrixString.split(";")) {
            String[] pair = param.split("=", 2);
            if (pair.length != 2) {
                throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
            }
            String name = URLDecoder.decode(pair[0], charset);
            String value = URLDecoder.decode(pair[1], charset);
            answer.put(name, value);
        }
        return answer;
    }

    private String arrayToString(Object[] array) {
        StringBuilder buffer = new StringBuilder("[");
        for (Object obj : array) {
            if (buffer.length() > 2) {
                buffer.append(",");
            }
            buffer.append(obj.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected CxfOperationException populateCxfRsProducerException(Exchange exchange, Response response, int responseCode) {
        CxfOperationException exception;
        String uri = exchange.getFromEndpoint().getEndpointUri();
        String statusText = this.statusTextFromResponseCode(responseCode);
        Map<String, String> headers = this.parseResponseHeaders(response, exchange);
        String copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, response.getEntity());
        if (responseCode >= 300 && responseCode < 400) {
            if (response.getMetadata().getFirst((Object)"Location") != null) {
                String redirectLocation = response.getMetadata().getFirst((Object)"location").toString();
                exception = new CxfOperationException(uri, responseCode, statusText, redirectLocation, headers, copy);
            } else {
                exception = new CxfOperationException(uri, responseCode, statusText, null, headers, copy);
            }
        } else {
            exception = new CxfOperationException(uri, responseCode, statusText, null, headers, copy);
        }
        return exception;
    }

    String statusTextFromResponseCode(int responseCode) {
        Response.Status status = Response.Status.fromStatusCode((int)responseCode);
        return status != null ? status.toString() : this.responseCategoryFromCode(responseCode);
    }

    private String responseCategoryFromCode(int responseCode) {
        return Response.Status.Family.familyOf((int)responseCode).name();
    }

    protected Map<String, String> parseResponseHeaders(Object response, Exchange camelExchange) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (response instanceof Response) {
            for (Map.Entry entry : ((Response)response).getMetadata().entrySet()) {
                LOG.trace("Parse external header {}={}", entry.getKey(), entry.getValue());
                answer.put((String)entry.getKey(), ((List)entry.getValue()).get(0).toString());
            }
        }
        return answer;
    }

    private Object getBody(Exchange exchange, Message inMessage, String httpMethod, CxfRsEndpoint cxfRsEndpoint, CxfRsBinding binding) throws Exception {
        Object body = null;
        if (!("GET".equals(httpMethod) || "DELETE".equals(httpMethod) && cxfRsEndpoint.isIgnoreDeleteMethodMessageBody())) {
            body = binding.bindCamelMessageBodyToRequestBody(inMessage, exchange);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request body = " + body);
            }
        }
        return body;
    }

    class ClientFactoryBeanCache {
        private LRUSoftCache<String, JAXRSClientFactoryBean> cache;

        ClientFactoryBeanCache(int maxCacheSize) {
            this.cache = new LRUSoftCache(maxCacheSize);
        }

        public void start() throws Exception {
            this.cache.resetStatistics();
        }

        public void stop() throws Exception {
            this.cache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JAXRSClientFactoryBean get(String address) throws Exception {
            JAXRSClientFactoryBean retVal = null;
            LRUSoftCache<String, JAXRSClientFactoryBean> lRUSoftCache = this.cache;
            synchronized (lRUSoftCache) {
                retVal = (JAXRSClientFactoryBean)this.cache.get((Object)address);
                if (retVal == null) {
                    retVal = ((CxfRsEndpoint)CxfRsProducer.this.getEndpoint()).createJAXRSClientFactoryBean(address);
                    this.cache.put((Object)address, (Object)retVal);
                    LOG.trace("Created client factory bean and add to cache for address '{}'", (Object)address);
                } else {
                    LOG.trace("Retrieved client factory bean from cache for address '{}'", (Object)address);
                }
            }
            return retVal;
        }
    }

    private final class CxfProxyInvocationCallback
    implements InvocationCallback<Object> {
        private final Exchange exchange;
        private final CxfRsEndpoint cxfRsEndpoint;
        private final AsyncCallback callback;
        private final Client client;

        private CxfProxyInvocationCallback(Client client, Exchange exchange, CxfRsEndpoint cxfRsEndpoint, AsyncCallback callback) {
            this.exchange = exchange;
            this.cxfRsEndpoint = cxfRsEndpoint;
            this.callback = callback;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(Object body) {
            try {
                Response response = this.client.getResponse();
                CxfRsProducer.this.saveCookies(this.exchange, this.client, this.cxfRsEndpoint.getCookieHandler());
                if (this.shouldHandleError(response)) {
                    this.handleError(response);
                    return;
                }
                if (!this.exchange.getPattern().isOutCapable()) {
                    return;
                }
                LOG.trace("Response body = {}", (Object)response);
                this.exchange.getOut().getHeaders().putAll(this.exchange.getIn().getHeaders());
                CxfRsBinding binding = this.cxfRsEndpoint.getBinding();
                this.exchange.getOut().getHeaders().putAll(binding.bindResponseHeadersToCamelHeaders(response, this.exchange));
                this.exchange.getOut().setBody(binding.bindResponseToCamelBody(body, this.exchange));
                this.exchange.getOut().setHeader("CamelHttpResponseCode", (Object)response.getStatus());
            }
            catch (Exception exception) {
                LOG.error("Error while processing response", (Throwable)exception);
                this.fail(exception);
            }
            finally {
                this.callback.done(false);
            }
        }

        public void failed(Throwable throwable) {
            LOG.error("Failed request ", throwable);
            try {
                CxfRsProducer.this.saveCookies(this.exchange, this.client, this.cxfRsEndpoint.getCookieHandler());
                this.fail(throwable);
            }
            catch (Exception error) {
                LOG.error("Error while processing failed request", (Throwable)error);
            }
            finally {
                this.callback.done(false);
            }
        }

        private void fail(Throwable throwable) {
            if (throwable.getClass().isInstance(WebApplicationException.class)) {
                WebApplicationException cast = (WebApplicationException)WebApplicationException.class.cast(throwable);
                Response response = cast.getResponse();
                if (this.shouldHandleError(response)) {
                    this.handleError(response);
                }
            } else if (throwable.getClass().isInstance(ResponseProcessingException.class)) {
                ResponseProcessingException cast = (ResponseProcessingException)ResponseProcessingException.class.cast(throwable);
                Response response = cast.getResponse();
                if (this.shouldHandleError(response)) {
                    this.handleError(response);
                }
            } else {
                this.exchange.setException(throwable);
            }
        }

        private void handleError(Response response) {
            this.exchange.setException((Throwable)((Object)CxfRsProducer.this.populateCxfRsProducerException(this.exchange, response, response.getStatus())));
        }

        private boolean shouldHandleError(Response response) {
            Integer respCode;
            return response != null && CxfRsProducer.this.throwException && (respCode = Integer.valueOf(response.getStatus())) > 207;
        }
    }

    private final class CxfInvocationCallback
    implements InvocationCallback<Response> {
        private final Exchange exchange;
        private final CxfRsEndpoint cxfRsEndpoint;
        private final Class<?> responseClass;
        private final AsyncCallback callback;
        private final Type genericType;
        private final Client client;

        private CxfInvocationCallback(Client client, Exchange exchange, CxfRsEndpoint cxfRsEndpoint, Class<?> responseClass, AsyncCallback callback, Type genericType) {
            this.exchange = exchange;
            this.cxfRsEndpoint = cxfRsEndpoint;
            this.responseClass = responseClass;
            this.callback = callback;
            this.genericType = genericType;
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(Response response) {
            try {
                if (this.shouldHandleError(response)) {
                    this.handleError(response);
                    return;
                }
                CxfRsProducer.this.saveCookies(this.exchange, this.client, this.cxfRsEndpoint.getCookieHandler());
                if (!this.exchange.getPattern().isOutCapable()) {
                    return;
                }
                LOG.trace("Response body = {}", (Object)response);
                this.exchange.getOut().getHeaders().putAll(this.exchange.getIn().getHeaders());
                CxfRsBinding binding = this.cxfRsEndpoint.getBinding();
                this.exchange.getOut().getHeaders().putAll(binding.bindResponseHeadersToCamelHeaders(response, this.exchange));
                if (this.genericType != null && !this.genericType.equals(Void.TYPE)) {
                    GenericType genericType = new GenericType(this.genericType);
                    this.exchange.getOut().setBody(binding.bindResponseToCamelBody(response.readEntity(genericType), this.exchange));
                } else if (this.responseClass != null && !this.responseClass.equals(Void.TYPE)) {
                    this.exchange.getOut().setBody(binding.bindResponseToCamelBody(response.readEntity(this.responseClass), this.exchange));
                } else {
                    this.exchange.getOut().setBody(binding.bindResponseToCamelBody(response, this.exchange));
                }
                this.exchange.getOut().setHeader("CamelHttpResponseCode", (Object)response.getStatus());
            }
            catch (Exception exception) {
                LOG.error("Error while processing response", (Throwable)exception);
                this.fail(exception);
            }
            finally {
                this.callback.done(false);
            }
        }

        public void failed(Throwable throwable) {
            LOG.error("Failed request ", throwable);
            try {
                CxfRsProducer.this.saveCookies(this.exchange, this.client, this.cxfRsEndpoint.getCookieHandler());
                this.fail(throwable);
            }
            catch (Exception error) {
                LOG.error("Error while processing failed request", (Throwable)error);
            }
            finally {
                this.callback.done(false);
            }
        }

        private void fail(Throwable throwable) {
            if (throwable.getClass().isInstance(WebApplicationException.class)) {
                WebApplicationException cast = (WebApplicationException)WebApplicationException.class.cast(throwable);
                Response response = cast.getResponse();
                if (this.shouldHandleError(response)) {
                    this.handleError(response);
                }
            } else if (throwable.getClass().isInstance(ResponseProcessingException.class)) {
                ResponseProcessingException cast = (ResponseProcessingException)ResponseProcessingException.class.cast(throwable);
                Response response = cast.getResponse();
                if (this.shouldHandleError(response)) {
                    this.handleError(response);
                }
            } else {
                this.exchange.setException(throwable);
            }
        }

        private boolean shouldHandleError(Response response) {
            Integer respCode;
            return response != null && CxfRsProducer.this.throwException && (respCode = Integer.valueOf(response.getStatus())) > 207;
        }

        private void handleError(Response response) {
            this.exchange.setException((Throwable)((Object)CxfRsProducer.this.populateCxfRsProducerException(this.exchange, response, response.getStatus())));
        }
    }
}

