/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.cluster;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.file.cluster.FileLockClusterLeaderInfo;
import org.apache.camel.component.file.cluster.FileLockClusterService;
import org.apache.camel.component.file.cluster.FileLockClusterUtils;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockClusterView
extends AbstractCamelClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockClusterView.class);
    private final ClusterMember localMember;
    private final Path leaderLockPath;
    private final Path leaderDataPath;
    private final AtomicReference<FileLockClusterLeaderInfo> clusterLeaderInfoRef = new AtomicReference();
    private RandomAccessFile leaderLockFile;
    private RandomAccessFile leaderDataFile;
    private FileLock lock;
    private ScheduledFuture<?> task;
    private int heartbeatTimeoutMultiplier;
    private long acquireLockIntervalDelayNanoseconds;

    FileLockClusterView(FileLockClusterService cluster, String namespace) {
        super((CamelClusterService)cluster, namespace);
        Objects.requireNonNull(cluster.getRoot(), "FileLockClusterService root directory must be specified");
        this.localMember = new ClusterMember();
        this.leaderLockPath = Paths.get(cluster.getRoot(), namespace);
        this.leaderDataPath = Paths.get(cluster.getRoot(), namespace + ".dat");
    }

    public Optional<CamelClusterMember> getLeader() {
        return this.localMember.isLeader() ? Optional.of(this.localMember) : Optional.empty();
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        return Collections.emptyList();
    }

    protected void doStart() throws Exception {
        if (this.leaderLockFile != null) {
            this.closeInternal();
            this.fireLeadershipChangedEvent(null);
        }
        if (!Files.exists(this.leaderLockPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.leaderLockPath.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(this.leaderLockPath, new LinkOption[0])) {
            Files.createFile(this.leaderLockPath, new FileAttribute[0]);
        }
        if (!Files.exists(this.leaderDataPath, new LinkOption[0])) {
            Files.createFile(this.leaderDataPath, new FileAttribute[0]);
        }
        FileLockClusterService service = (FileLockClusterService)this.getClusterService().unwrap(FileLockClusterService.class);
        this.acquireLockIntervalDelayNanoseconds = TimeUnit.NANOSECONDS.convert(service.getAcquireLockInterval(), service.getAcquireLockIntervalUnit());
        this.heartbeatTimeoutMultiplier = service.getHeartbeatTimeoutMultiplier();
        if (this.heartbeatTimeoutMultiplier <= 0) {
            throw new IllegalArgumentException("HeartbeatTimeoutMultiplier must be greater than 0");
        }
        ScheduledExecutorService executor = service.getExecutor();
        this.task = executor.scheduleWithFixedDelay(this::tryLock, TimeUnit.MILLISECONDS.convert(service.getAcquireLockDelay(), service.getAcquireLockDelayUnit()), TimeUnit.MILLISECONDS.convert(service.getAcquireLockInterval(), service.getAcquireLockIntervalUnit()), TimeUnit.MILLISECONDS);
        this.localMember.setStatus(ClusterMemberStatus.STARTED);
    }

    protected void doStop() throws Exception {
        if (this.localMember.isLeader() && this.leaderDataFile != null) {
            try {
                FileChannel channel = this.leaderDataFile.getChannel();
                channel.truncate(0L);
                channel.force(true);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to truncate {} on {} stop", new Object[]{this.leaderDataPath, ((Object)((Object)this)).getClass().getSimpleName(), e});
            }
        }
        this.closeInternal();
        this.localMember.setStatus(ClusterMemberStatus.STOPPED);
        this.clusterLeaderInfoRef.set(null);
    }

    private void closeInternal() {
        if (this.task != null) {
            this.task.cancel(true);
        }
        this.releaseFileLock();
        this.closeLockFiles();
    }

    private void closeLockFiles() {
        if (this.leaderLockFile != null) {
            try {
                this.leaderLockFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.leaderLockFile = null;
        }
        if (this.leaderDataFile != null) {
            try {
                this.leaderDataFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.leaderDataFile = null;
        }
    }

    private void releaseFileLock() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void tryLock() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean isLeaderStale(FileLockClusterLeaderInfo clusterLeaderInfo, FileLockClusterLeaderInfo previousClusterLeaderInfo) {
        return FileLockClusterUtils.isLeaderStale(clusterLeaderInfo, previousClusterLeaderInfo, System.nanoTime(), this.heartbeatTimeoutMultiplier);
    }

    boolean canReclaimLeadership(FileLockClusterLeaderInfo leaderInfo) {
        return leaderInfo != null && this.localMember.getUuid().equals(leaderInfo.getId());
    }

    void writeClusterLeaderInfo(boolean forceMetaData) throws IOException {
        FileLockClusterLeaderInfo latestClusterLeaderInfo = new FileLockClusterLeaderInfo(this.localMember.getUuid(), this.acquireLockIntervalDelayNanoseconds, System.nanoTime());
        FileLockClusterUtils.writeClusterLeaderInfo(this.leaderDataPath, this.leaderDataFile.getChannel(), latestClusterLeaderInfo, forceMetaData);
    }

    boolean isLeaderInternal() {
        if (this.localMember.isLeader()) {
            try {
                FileLockClusterLeaderInfo leaderInfo = FileLockClusterUtils.readClusterLeaderInfo(this.leaderDataPath);
                return this.lock != null && this.lock.isValid() && Files.exists(this.leaderLockPath, new LinkOption[0]) && leaderInfo != null && this.localMember.getUuid().equals(leaderInfo.getId());
            }
            catch (Exception e) {
                LOGGER.debug("Failed to read {} (cluster-member-id={})", new Object[]{this.leaderLockPath, this.localMember.getUuid(), e});
                return false;
            }
        }
        return false;
    }

    private final class ClusterMember
    implements CamelClusterMember {
        private final AtomicReference<ClusterMemberStatus> status = new AtomicReference<ClusterMemberStatus>(ClusterMemberStatus.STOPPED);
        private final String uuid = UUID.randomUUID().toString();

        private ClusterMember() {
        }

        public boolean isLeader() {
            return this.getStatus().equals((Object)ClusterMemberStatus.LEADER);
        }

        public boolean isLocal() {
            return true;
        }

        public String getId() {
            return FileLockClusterView.this.getClusterService().getId();
        }

        public String getUuid() {
            return this.uuid;
        }

        public ClusterMemberStatus getStatus() {
            return this.status.get();
        }

        private void setStatus(ClusterMemberStatus status) {
            this.status.set(status);
        }
    }

    private static enum ClusterMemberStatus {
        FOLLOWER,
        LEADER,
        STARTED,
        STOPPED;

    }
}

