/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

public class CamelProxyRoutePlanner
extends DefaultProxyRoutePlanner {
    private final Set<String> exactMatches = new HashSet<String>();
    private final List<Pattern> wildcardPatterns = new ArrayList<Pattern>();

    public CamelProxyRoutePlanner(HttpHost proxy, Set<String> noProxyHosts) {
        super(proxy);
        this.compilePatterns(noProxyHosts);
    }

    public CamelProxyRoutePlanner(HttpHost proxy, SchemePortResolver schemePortResolver, Set<String> noProxyHosts) {
        super(proxy, schemePortResolver);
        this.compilePatterns(noProxyHosts);
    }

    private void compilePatterns(Set<String> noProxyHosts) {
        if (noProxyHosts == null || noProxyHosts.isEmpty()) {
            return;
        }
        for (String pattern : noProxyHosts) {
            if (pattern == null || pattern.isEmpty()) continue;
            if (pattern.contains("*")) {
                String regex = pattern.replace(".", "\\.").replace("*", ".*");
                this.wildcardPatterns.add(Pattern.compile(regex, 2));
                continue;
            }
            this.exactMatches.add(pattern.toLowerCase());
        }
    }

    private boolean matchesNoProxyHost(String hostname) {
        if (hostname == null) {
            return false;
        }
        if (this.exactMatches.contains(hostname.toLowerCase())) {
            return true;
        }
        for (Pattern pattern : this.wildcardPatterns) {
            if (!pattern.matcher(hostname).matches()) continue;
            return true;
        }
        return false;
    }

    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        if (this.exactMatches.isEmpty() && this.wildcardPatterns.isEmpty()) {
            return super.determineProxy(target, context);
        }
        String targetHost = target.getHostName();
        if (this.matchesNoProxyHost(targetHost)) {
            return null;
        }
        return super.determineProxy(target, context);
    }
}

