/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.component.http.CamelProxyRoutePlanner;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpHost;

public class ProxyHttpClientConfigurer
implements HttpClientConfigurer {
    private final String host;
    private final Integer port;
    private final String scheme;
    private final String username;
    private final char[] password;
    private final String domain;
    private final String ntHost;
    private final HttpCredentialsHelper credentialsHelper;
    private final Set<String> nonProxyHosts;

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme) {
        this(host, port, scheme, null, null, null, null, null, null);
    }

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme, String nonProxyHosts) {
        this(host, port, scheme, null, null, null, null, null, nonProxyHosts);
    }

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme, String username, String password, String domain, String ntHost, HttpCredentialsHelper credentialsHelper, String nonProxyHosts) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.username = username;
        this.password = password == null ? new char[]{} : password.toCharArray();
        this.domain = domain;
        this.ntHost = ntHost;
        this.credentialsHelper = credentialsHelper;
        this.nonProxyHosts = Optional.ofNullable(nonProxyHosts).stream().flatMap(s -> Arrays.stream(s.split(","))).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        HttpHost proxy = new HttpHost(this.scheme, this.host, this.port.intValue());
        if (this.nonProxyHosts.isEmpty()) {
            clientBuilder.setProxy(proxy);
        } else {
            CamelProxyRoutePlanner nonProxyHostsAwareRoutePlanner = new CamelProxyRoutePlanner(proxy, this.nonProxyHosts);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)nonProxyHostsAwareRoutePlanner);
        }
        if (this.username != null && this.password != null) {
            Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.ntHost, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
            clientBuilder.setDefaultCredentialsProvider(this.credentialsHelper.getCredentialsProvider(this.host, this.port, (Credentials)defaultcreds));
        }
    }
}

