/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import java.util.Objects;
import org.apache.camel.component.iec60870.BaseOptions;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleOptions;

@UriParams
public class ServerOptions
extends BaseOptions<ServerOptions> {
    @UriParam(javaType="DataModuleOptions", label="data")
    private DataModuleOptions.Builder dataModuleOptions;
    @UriParam(label="data")
    private Integer bufferingPeriod;
    @UriParam(label="data", defaultValue="true")
    private boolean booleansWithTimestamp;
    @UriParam(label="data", defaultValue="true")
    private boolean floatsWithTimestamp;
    @UriParam(label="data", defaultValue="10")
    private int spontaneousDuplicates;
    @UriParam(label="data", defaultValue="60000")
    private int backgroundScanPeriod;

    public ServerOptions() {
        this.dataModuleOptions = new DataModuleOptions.Builder();
    }

    public ServerOptions(ServerOptions other) {
        this(other.getProtocolOptions(), other.getDataModuleOptions());
    }

    public ServerOptions(ProtocolOptions protocolOptions, DataModuleOptions dataModuleOptions) {
        super(protocolOptions);
        Objects.requireNonNull(dataModuleOptions);
        this.dataModuleOptions = new DataModuleOptions.Builder(dataModuleOptions);
    }

    @Override
    public ServerOptions copy() {
        return new ServerOptions(this);
    }

    public void setDataModuleOptions(DataModuleOptions dataModuleOptions) {
        Objects.requireNonNull(dataModuleOptions);
        this.dataModuleOptions = new DataModuleOptions.Builder(dataModuleOptions);
    }

    public void setBufferingPeriod(Integer bufferingPeriod) {
        this.bufferingPeriod = bufferingPeriod;
    }

    public Integer getBufferingPeriod() {
        return this.bufferingPeriod;
    }

    public DataModuleOptions getDataModuleOptions() {
        return this.dataModuleOptions.build();
    }

    public void setBooleansWithTimestamp(boolean booleansWithTimestamp) {
        this.dataModuleOptions.setBooleansWithTimestamp(booleansWithTimestamp);
    }

    public boolean isBooleansWithTimestamp() {
        return this.dataModuleOptions.isBooleansWithTimestamp();
    }

    public void setFloatsWithTimestamp(boolean floatsWithTimestamp) {
        this.dataModuleOptions.setFloatsWithTimestamp(floatsWithTimestamp);
    }

    public boolean isFloatsWithTimestamp() {
        return this.dataModuleOptions.isFloatsWithTimestamp();
    }

    public void setSpontaneousDuplicates(int spontaneousDuplicates) {
        this.dataModuleOptions.setSpontaneousDuplicates(spontaneousDuplicates);
    }

    public int getSpontaneousDuplicates() {
        return this.dataModuleOptions.getSpontaneousDuplicates();
    }

    public void setBackgroundScanPeriod(int backgroundScanPeriod) {
        this.dataModuleOptions.setBackgroundScanPeriod(backgroundScanPeriod);
    }

    public int getBackgroundScanPeriod() {
        return this.dataModuleOptions.getBackgroundScanPeriod();
    }
}

