/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.micrometer.json.MicrometerModule;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.service.ServiceSupport;

public class AbstractMicrometerService
extends ServiceSupport {
    private CamelContext camelContext;
    private MeterRegistry meterRegistry;
    private boolean prettyPrint = true;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private Iterable<Tag> matchingTags = Tags.empty();
    private Predicate<String> matchingNames;
    private transient ObjectMapper mapper;
    private transient ObjectMapper secondsMapper;

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public Iterable<Tag> getMatchingTags() {
        return this.matchingTags;
    }

    public void setMatchingTags(Iterable<Tag> matchingTags) {
        this.matchingTags = matchingTags;
    }

    public Predicate<String> getMatchingNames() {
        return this.matchingNames;
    }

    public void setMatchingNames(Predicate<String> matchingNames) {
        this.matchingNames = matchingNames;
    }

    public String dumpStatisticsAsJson() {
        ObjectWriter writer = this.mapper.writer();
        if (this.isPrettyPrint()) {
            writer = writer.withDefaultPrettyPrinter();
        }
        try {
            return writer.writeValueAsString((Object)this.getMeterRegistry());
        }
        catch (JsonProcessingException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String dumpStatisticsAsJsonTimeUnitSeconds() {
        ObjectWriter writer = this.secondsMapper.writer();
        if (this.isPrettyPrint()) {
            writer = writer.withDefaultPrettyPrinter();
        }
        try {
            return writer.writeValueAsString((Object)this.getMeterRegistry());
        }
        catch (JsonProcessingException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected void doStart() {
        if (this.meterRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.meterRegistry = (MeterRegistry)camelRegistry.lookupByNameAndType("metricsRegistry", MeterRegistry.class);
            if (this.meterRegistry == null) {
                this.meterRegistry = new SimpleMeterRegistry();
            }
        }
        this.mapper = new ObjectMapper().registerModule((Module)new MicrometerModule(this.getDurationUnit(), this.getMatchingNames(), this.getMatchingTags()));
        this.secondsMapper = this.getDurationUnit() == TimeUnit.SECONDS ? this.mapper : new ObjectMapper().registerModule((Module)new MicrometerModule(TimeUnit.SECONDS, this.getMatchingNames(), this.getMatchingTags()));
    }

    protected void doStop() {
    }
}

