/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.component.quartz.CamelJob;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.component.quartz.QuartzConsumer;
import org.apache.camel.component.quartz.QuartzHelper;
import org.apache.camel.component.quartz.StatefulCamelJob;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.quartz.Calendar;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.12.0", scheme="quartz", title="Quartz", syntax="quartz:groupName/triggerName", remote=false, consumerOnly=true, category={Category.SCHEDULING})
public class QuartzEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzEndpoint.class);
    private TriggerKey triggerKey;
    private volatile AsyncProcessor processor;
    private final AtomicBoolean jobAdded = new AtomicBoolean();
    private final AtomicBoolean jobPaused = new AtomicBoolean();
    @UriPath(description="The quartz group name to use. The combination of group name and trigger name should be unique.", defaultValue="Camel")
    private String groupName;
    @UriPath(description="The quartz trigger name to use. The combination of group name and trigger name should be unique.")
    @Metadata(required=true)
    private String triggerName;
    @UriParam
    private String cron;
    @UriParam
    private boolean stateful;
    @UriParam(label="advanced")
    private boolean ignoreExpiredNextFireTime;
    @UriParam(defaultValue="true")
    private boolean deleteJob = true;
    @UriParam
    private boolean pauseJob;
    @UriParam
    private boolean durableJob;
    @UriParam
    private boolean recoverableJob;
    @UriParam(label="scheduler", defaultValue="500", javaType="java.time.Duration")
    private long triggerStartDelay = 500L;
    @UriParam(label="scheduler", defaultValue="true")
    private boolean autoStartScheduler = true;
    @UriParam(label="advanced")
    private boolean usingFixedCamelContextName;
    @UriParam(label="advanced")
    private boolean prefixJobNameWithEndpointId;
    @UriParam(prefix="trigger.", multiValue=true, label="advanced")
    private Map<String, Object> triggerParameters;
    @UriParam(prefix="job.", multiValue=true, label="advanced")
    private Map<String, Object> jobParameters;
    @UriParam(label="advanced")
    private Calendar customCalendar;

    public QuartzEndpoint(String uri, QuartzComponent quartzComponent) {
        super(uri, (Component)quartzComponent);
    }

    public boolean isRemote() {
        return false;
    }

    public String getGroupName() {
        return this.triggerKey.getGroup();
    }

    public String getTriggerName() {
        return this.triggerKey.getName();
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getCron() {
        return this.cron;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isIgnoreExpiredNextFireTime() {
        return this.ignoreExpiredNextFireTime;
    }

    public void setIgnoreExpiredNextFireTime(boolean ignoreExpiredNextFireTime) {
        this.ignoreExpiredNextFireTime = ignoreExpiredNextFireTime;
    }

    public long getTriggerStartDelay() {
        return this.triggerStartDelay;
    }

    public boolean isDeleteJob() {
        return this.deleteJob;
    }

    public boolean isPauseJob() {
        return this.pauseJob;
    }

    public void setPauseJob(boolean pauseJob) {
        this.pauseJob = pauseJob;
    }

    public void setTriggerStartDelay(long triggerStartDelay) {
        this.triggerStartDelay = triggerStartDelay;
    }

    public void setDeleteJob(boolean deleteJob) {
        this.deleteJob = deleteJob;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public boolean isDurableJob() {
        return this.durableJob;
    }

    public void setDurableJob(boolean durableJob) {
        this.durableJob = durableJob;
    }

    public boolean isRecoverableJob() {
        return this.recoverableJob;
    }

    public void setRecoverableJob(boolean recoverableJob) {
        this.recoverableJob = recoverableJob;
    }

    public boolean isUsingFixedCamelContextName() {
        return this.usingFixedCamelContextName;
    }

    public void setUsingFixedCamelContextName(boolean usingFixedCamelContextName) {
        this.usingFixedCamelContextName = usingFixedCamelContextName;
    }

    public Map<String, Object> getTriggerParameters() {
        return this.triggerParameters;
    }

    public void setTriggerParameters(Map<String, Object> triggerParameters) {
        this.triggerParameters = triggerParameters;
    }

    public Map<String, Object> getJobParameters() {
        return this.jobParameters;
    }

    public void setJobParameters(Map<String, Object> jobParameters) {
        this.jobParameters = jobParameters;
    }

    public boolean isAutoStartScheduler() {
        return this.autoStartScheduler;
    }

    public void setAutoStartScheduler(boolean autoStartScheduler) {
        this.autoStartScheduler = autoStartScheduler;
    }

    public boolean isPrefixJobNameWithEndpointId() {
        return this.prefixJobNameWithEndpointId;
    }

    public void setPrefixJobNameWithEndpointId(boolean prefixJobNameWithEndpointId) {
        this.prefixJobNameWithEndpointId = prefixJobNameWithEndpointId;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public TriggerKey getTriggerKey() {
        return this.triggerKey;
    }

    public void setTriggerKey(TriggerKey triggerKey) {
        this.triggerKey = triggerKey;
    }

    public Calendar getCustomCalendar() {
        return this.customCalendar;
    }

    public void setCustomCalendar(Calendar customCalendar) {
        this.customCalendar = customCalendar;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Quartz producer is not supported.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        QuartzConsumer result = new QuartzConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)result);
        return result;
    }

    protected void doStart() throws Exception {
        if (this.isDeleteJob() && this.isPauseJob()) {
            throw new IllegalArgumentException("Cannot have both options deleteJob and pauseJob enabled");
        }
        if (ObjectHelper.isNotEmpty((Object)this.customCalendar)) {
            this.getComponent().getScheduler().addCalendar("CamelQuartzCustomCalendar", this.customCalendar, true, false);
        }
        this.addJobInScheduler();
    }

    protected void doStop() throws Exception {
        this.removeJobInScheduler();
    }

    private void removeJobInScheduler() throws Exception {
        Scheduler scheduler = this.getComponent().getScheduler();
        if (scheduler == null) {
            return;
        }
        if (this.deleteJob) {
            boolean isClustered = scheduler.getMetaData().isJobStoreClustered();
            if (!scheduler.isShutdown() && !isClustered) {
                LOG.info("Deleting job {}", (Object)this.triggerKey);
                scheduler.unscheduleJob(this.triggerKey);
                this.jobAdded.set(false);
            }
        } else if (this.pauseJob) {
            this.pauseTrigger();
        }
        AtomicInteger number = (AtomicInteger)scheduler.getContext().get((Object)"CamelQuartzJobsCount");
        if (number != null) {
            number.decrementAndGet();
        }
    }

    private void addJobInScheduler() throws Exception {
        AtomicInteger number;
        boolean scheduled;
        Trigger trigger;
        JobDetail jobDetail;
        Scheduler scheduler;
        block12: {
            boolean triggerExisted;
            scheduler = this.getComponent().getScheduler();
            Trigger oldTrigger = scheduler.getTrigger(this.triggerKey);
            boolean bl = triggerExisted = oldTrigger != null;
            if (triggerExisted && !this.isRecoverableJob()) {
                this.ensureNoDupTriggerKey();
            }
            jobDetail = this.createJobDetail();
            trigger = this.createTrigger(jobDetail);
            QuartzHelper.updateJobDataMap(this.getCamelContext(), jobDetail, this.getEndpointUri(), this.isUsingFixedCamelContextName());
            scheduled = true;
            if (triggerExisted) {
                if (this.hasTriggerChanged(oldTrigger, trigger)) {
                    scheduler.rescheduleJob(this.triggerKey, trigger);
                }
            } else {
                try {
                    if (this.hasTriggerExpired(scheduler, trigger)) {
                        scheduled = false;
                        LOG.warn("Job {} (cron={}, triggerType={}, jobClass={}) not scheduled, because it will never fire in the future", new Object[]{trigger.getKey(), this.cron, trigger.getClass().getSimpleName(), jobDetail.getJobClass().getSimpleName()});
                    } else {
                        scheduler.scheduleJob(jobDetail, trigger);
                    }
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (!this.getComponent().isClustered()) {
                        throw ex;
                    }
                    trigger = scheduler.getTrigger(this.triggerKey);
                    if (trigger != null) break block12;
                    throw new SchedulerException("Trigger could not be found in quartz scheduler.");
                }
            }
        }
        if (scheduled && LOG.isInfoEnabled()) {
            Object nextFireTime = trigger.getNextFireTime();
            if (nextFireTime != null) {
                nextFireTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(nextFireTime);
            }
            LOG.info("Job {} (cron={}, triggerType={}, jobClass={}) is scheduled. Next fire date is {}", new Object[]{trigger.getKey(), this.cron, trigger.getClass().getSimpleName(), jobDetail.getJobClass().getSimpleName(), nextFireTime});
        }
        if ((number = (AtomicInteger)scheduler.getContext().get((Object)"CamelQuartzJobsCount")) != null) {
            number.incrementAndGet();
        }
        this.jobAdded.set(true);
    }

    private boolean hasTriggerExpired(Scheduler scheduler, Trigger trigger) throws SchedulerException {
        OperableTrigger ot;
        Calendar cal = null;
        if (trigger.getCalendarName() != null) {
            cal = scheduler.getCalendar(trigger.getCalendarName());
        }
        if ((ot = (OperableTrigger)trigger).getEndTime() != null && new Date().after(ot.getEndTime())) {
            return true;
        }
        Date ft = ot.computeFirstFireTime(cal);
        return ft == null && this.ignoreExpiredNextFireTime;
    }

    private boolean hasTriggerChanged(Trigger oldTrigger, Trigger newTrigger) {
        if (newTrigger instanceof CronTrigger && oldTrigger instanceof CronTrigger) {
            CronTrigger newCron = (CronTrigger)newTrigger;
            CronTrigger oldCron = (CronTrigger)oldTrigger;
            return !newCron.getCronExpression().equals(oldCron.getCronExpression());
        }
        if (newTrigger instanceof SimpleTrigger && oldTrigger instanceof SimpleTrigger) {
            SimpleTrigger newSimple = (SimpleTrigger)newTrigger;
            SimpleTrigger oldSimple = (SimpleTrigger)oldTrigger;
            return newSimple.getRepeatInterval() != oldSimple.getRepeatInterval() || newSimple.getRepeatCount() != oldSimple.getRepeatCount();
        }
        return !newTrigger.getClass().equals(oldTrigger.getClass()) || !newTrigger.equals((Object)oldTrigger);
    }

    private void ensureNoDupTriggerKey() {
        for (Route route : this.getCamelContext().getRoutes()) {
            QuartzEndpoint quartzEndpoint;
            TriggerKey checkTriggerKey;
            if (!(route.getEndpoint() instanceof QuartzEndpoint) || !this.triggerKey.equals((Object)(checkTriggerKey = (quartzEndpoint = (QuartzEndpoint)route.getEndpoint()).getTriggerKey()))) continue;
            throw new IllegalArgumentException("Trigger key " + String.valueOf(this.triggerKey) + " is already in use by " + String.valueOf((Object)quartzEndpoint));
        }
    }

    private Trigger createTrigger(JobDetail jobDetail) throws Exception {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.triggerParameters);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.triggerKey);
        if (this.getComponent().getScheduler().isStarted() || this.triggerStartDelay < 0L) {
            triggerBuilder.startAt(new Date(System.currentTimeMillis() + this.triggerStartDelay));
        }
        if (this.cron != null) {
            String timeZone;
            String endAt;
            LOG.debug("Creating CronTrigger: {}", (Object)this.cron);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            String startAt = (String)copy.get("startAt");
            if (startAt != null) {
                triggerBuilder.startAt(dateFormat.parse(startAt));
            }
            if ((endAt = (String)copy.get("endAt")) != null) {
                Date endDate = dateFormat.parse(endAt);
                if (endDate.before(new Date()) && startAt == null && this.isIgnoreExpiredNextFireTime()) {
                    triggerBuilder.startAt(Date.from(endDate.toInstant().minusSeconds(1L)));
                }
                triggerBuilder.endAt(endDate);
            }
            if ((timeZone = (String)copy.get("timeZone")) != null) {
                if (ObjectHelper.isNotEmpty((Object)this.customCalendar)) {
                    triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed().inTimeZone(TimeZone.getTimeZone(timeZone))).modifiedByCalendar("CamelQuartzCustomCalendar");
                } else {
                    triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed().inTimeZone(TimeZone.getTimeZone(timeZone)));
                }
                jobDetail.getJobDataMap().put("CamelQuartzTriggerCronTimeZone", timeZone);
            } else if (ObjectHelper.isNotEmpty((Object)this.customCalendar)) {
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed()).modifiedByCalendar("CamelQuartzCustomCalendar");
            } else {
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed());
            }
            jobDetail.getJobDataMap().put("CamelQuartzTriggerType", "cron");
            jobDetail.getJobDataMap().put("CamelQuartzTriggerCronExpression", this.cron);
        } else {
            LOG.debug("Creating SimpleTrigger.");
            int repeat = -1;
            String repeatString = (String)copy.get("repeatCount");
            if (repeatString != null) {
                repeat = (Integer)EndpointHelper.resolveParameter((CamelContext)this.getCamelContext(), (String)repeatString, Integer.class);
                copy.put("repeatCount", repeat);
            }
            long interval = 1000L;
            String intervalString = (String)copy.get("repeatInterval");
            if (intervalString != null) {
                interval = (Long)EndpointHelper.resolveParameter((CamelContext)this.getCamelContext(), (String)intervalString, Long.class);
                copy.put("repeatInterval", interval);
            }
            if (ObjectHelper.isNotEmpty((Object)this.customCalendar)) {
                triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow().withRepeatCount(repeat).withIntervalInMilliseconds(interval)).modifiedByCalendar("CamelQuartzCustomCalendar");
            } else {
                triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow().withRepeatCount(repeat).withIntervalInMilliseconds(interval));
            }
            jobDetail.getJobDataMap().put("CamelQuartzTriggerType", "simple");
            jobDetail.getJobDataMap().put("CamelQuartzTriggerSimpleRepeatCounter", String.valueOf(repeat));
            jobDetail.getJobDataMap().put("CamelQuartzTriggerSimpleRepeatInterval", String.valueOf(interval));
        }
        Trigger result = triggerBuilder.build();
        if (!copy.isEmpty()) {
            LOG.debug("Setting user extra triggerParameters {}", copy);
            this.setProperties(result, copy);
        }
        LOG.debug("Created trigger={}", (Object)result);
        return result;
    }

    private JobDetail createJobDetail() {
        String name = this.triggerKey.getName();
        String group = this.triggerKey.getGroup();
        Class jobClass = this.stateful ? StatefulCamelJob.class : CamelJob.class;
        LOG.debug("Creating new {}.", (Object)jobClass.getSimpleName());
        JobBuilder builder = JobBuilder.newJob((Class)jobClass).withIdentity(name, group);
        if (this.durableJob) {
            builder = builder.storeDurably();
        }
        if (this.recoverableJob) {
            builder = builder.requestRecovery();
        }
        JobDetail result = builder.build();
        if (this.jobParameters != null && this.jobParameters.size() > 0) {
            HashMap<String, Object> copy = new HashMap<String, Object>(this.jobParameters);
            LOG.debug("Setting user extra jobParameters {}", copy);
            this.setProperties(result, copy);
        }
        LOG.debug("Created jobDetail={}", (Object)result);
        return result;
    }

    public QuartzComponent getComponent() {
        return (QuartzComponent)super.getComponent();
    }

    public void pauseTrigger() throws Exception {
        Scheduler scheduler = this.getComponent().getScheduler();
        boolean isClustered = scheduler.getMetaData().isJobStoreClustered();
        if (this.jobPaused.get() || isClustered) {
            return;
        }
        this.jobPaused.set(true);
        if (!scheduler.isShutdown()) {
            LOG.info("Pausing trigger {}", (Object)this.triggerKey);
            scheduler.pauseTrigger(this.triggerKey);
        }
    }

    public void resumeTrigger() throws Exception {
        if (!this.jobPaused.get()) {
            return;
        }
        this.jobPaused.set(false);
        Scheduler scheduler = this.getComponent().getScheduler();
        if (scheduler != null) {
            LOG.info("Resuming trigger {}", (Object)this.triggerKey);
            scheduler.resumeTrigger(this.triggerKey);
        }
    }

    public void onConsumerStart(QuartzConsumer quartzConsumer) throws Exception {
        this.processor = quartzConsumer.getAsyncProcessor();
        if (!this.jobAdded.get()) {
            this.addJobInScheduler();
        } else {
            this.resumeTrigger();
        }
    }

    public void onConsumerStop(QuartzConsumer quartzConsumer) throws Exception {
        if (this.jobAdded.get()) {
            this.pauseTrigger();
        }
        this.processor = null;
    }

    AsyncProcessor getProcessor() {
        return this.processor;
    }
}

