/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.reply;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.TimeoutMap;
import org.apache.camel.component.rabbitmq.reply.ReplyHandler;
import org.apache.camel.support.DefaultTimeoutMap;

class CorrelationTimeoutMap
extends DefaultTimeoutMap<String, ReplyHandler> {
    CorrelationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        super(executor, requestMapPollTimeMillis);
        this.addListener(this::listener);
    }

    private static long encode(long timeoutMillis) {
        return timeoutMillis > 0L ? timeoutMillis : Integer.MAX_VALUE;
    }

    private void listener(TimeoutMap.Listener.Type type, String key, ReplyHandler handler) {
        if (type == TimeoutMap.Listener.Type.Put) {
            this.log.trace("Added correlationID: {}", (Object)key);
        } else if (type == TimeoutMap.Listener.Type.Remove) {
            this.log.trace("Removed correlationID: {}", (Object)key);
        } else if (type == TimeoutMap.Listener.Type.Evict) {
            try {
                handler.onTimeout(key);
            }
            catch (Throwable e) {
                this.log.warn("Error processing onTimeout for correlationID: " + key + " due: " + e.getMessage() + ". This exception is ignored.", e);
            }
            this.log.trace("Evicted correlationID: {}", (Object)key);
        }
    }

    public ReplyHandler put(String key, ReplyHandler value, long timeoutMillis) {
        return (ReplyHandler)super.put((Object)key, (Object)value, CorrelationTimeoutMap.encode(timeoutMillis));
    }

    public ReplyHandler putIfAbsent(String key, ReplyHandler value, long timeoutMillis) {
        return (ReplyHandler)super.putIfAbsent((Object)key, (Object)value, CorrelationTimeoutMap.encode(timeoutMillis));
    }
}

