/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip.listener;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.header.Header;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.sip.SipSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipSubscriptionListener
implements SipListener {
    private static final Logger LOG = LoggerFactory.getLogger(SipSubscriptionListener.class);
    private SipSubscriber sipSubscriber;
    private Dialog subscriberDialog;
    private Dialog forkedDialog;

    public SipSubscriptionListener(SipSubscriber sipSubscriber) {
        this.setSipSubscriber(sipSubscriber);
    }

    private void dispatchExchange(Object response) throws CamelException {
        LOG.debug("Consumer Dispatching the received notification along the route");
        Exchange exchange = this.sipSubscriber.getEndpoint().createExchange(ExchangePattern.InOnly);
        exchange.getIn().setBody(response);
        try {
            this.sipSubscriber.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new CamelException("Error in consumer while dispatching exchange", (Throwable)e);
        }
    }

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        String viaBranch = ((ViaHeader)request.getHeaders("Via").next()).getParameter("branch");
        LOG.debug("Request: {}", (Object)request.getMethod());
        LOG.debug("Server Transaction Id: {}", (Object)serverTransactionId);
        LOG.debug("Received From Branch: {}", (Object)viaBranch);
        if (request.getMethod().equals("NOTIFY")) {
            this.processNotify(requestReceivedEvent, serverTransactionId);
        }
    }

    public synchronized void processNotify(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        LOG.debug("Notification received at Subscriber");
        SipProvider provider = (SipProvider)requestEvent.getSource();
        Request notify = requestEvent.getRequest();
        try {
            Dialog dialog;
            if (serverTransactionId == null) {
                LOG.info("ServerTransaction is null. Creating new Server transaction");
                serverTransactionId = provider.getNewServerTransaction(notify);
            }
            if ((dialog = serverTransactionId.getDialog()) != this.subscriberDialog) {
                this.forkedDialog = dialog;
            }
            this.dispatchExchange(notify.getContent());
            Response response = this.sipSubscriber.getConfiguration().getMessageFactory().createResponse(200, notify);
            response.addHeader((Header)this.sipSubscriber.getConfiguration().getContactHeader());
            serverTransactionId.sendResponse(response);
            SubscriptionStateHeader subscriptionState = (SubscriptionStateHeader)notify.getHeader("Subscription-State");
            if (subscriptionState.getState().equalsIgnoreCase("terminated")) {
                LOG.info("Subscription state is terminated. Deleting the current dialog");
                dialog.delete();
            }
        }
        catch (Exception e) {
            LOG.error("Exception thrown during Notify processing in the SipSubscriptionListener.", (Throwable)e);
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        LOG.debug("Response received at Subscriber");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction clientTransactionId = responseReceivedEvent.getClientTransaction();
        LOG.debug("Response received with client transaction id {}:{}", (Object)clientTransactionId, (Object)response.getStatusCode());
        if (clientTransactionId == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Stray response -- dropping");
            }
            return;
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("IOExceptionEvent received at Sip Subscription Listener");
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("TransactionTerminatedEvent received at Sip Subscription Listener");
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("DialogTerminatedEvent received at Sip Subscription Listener");
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("TimeoutEvent received at Sip Subscription Listener");
        }
    }

    public void setSipSubscriber(SipSubscriber sipSubscriber) {
        this.sipSubscriber = sipSubscriber;
    }

    public SipSubscriber getSipSubscriber() {
        return this.sipSubscriber;
    }

    public Dialog getForkedDialog() {
        return this.forkedDialog;
    }
}

